PSCAD 4.2.0

Settings
 {
 Id = "976141504.1144771295"
 Author = "jayas.jayas"
 Desc = "Parallel Transmission Line using Multiple Run"
 Arch = "windows"
 Options = 0
 Build = 19
 Warn = 7
 Check = 15
 Libs = ""
 Source = ""
 RunInfo = 
  {
  Fin = 0.5
  Step = 5e-005
  Plot = 0.001
  Chat = 0.001
  Brch = 0.0005
  Lat = 100
  Options = 0
  Advanced = 511
  Debug = 0
  StartFile = ""
  OFile = "noname.out"
  SFile = "noname.snp"
  SnapTime = 0.5
  Mruns = 10
  Mrunfile = 0
  StartType = 0
  PlotType = 0
  SnapType = 0
  MrunType = "mrun"
  }


Global_Consts = 
  {
  f = 60.0 [Hz]
  }

 }

Definitions
 {
 Module("Controls")
  {
  Desc = ""
  FileDate = 1144770343
  Nodes = 
   {
   Output("F",54,36)
    {
    Type = Integer
    }
   Input("V",54,18)
    {
    Type = Real
    Dim  = [3]
    }
   Input("Flt_en",54,0)
    {
    Type = Integer
    }
   Input("I",54,-18)
    {
    Type = Real
    Dim  = [3]
    }
   Output("B",54,-36)
    {
    Type = Integer
    Dim  = [6]
    }
   }

  Graphics = 
   {
   Brush(Solid,Yellow)
   Rectangle(-25,-43,25,40)
   Pen(Gray)
   Brush(,Silver)
   Rectangle(0,-13,3,0)
   Pen(Black)
   Line(25,0,54,0)
   Pen(Gray)
   Brush(,Gray)
   Rectangle(-3,-10,6,-7)
   Pen(ByNode)
   Brush(Hollow)
   Rectangle(-4,-18,7,3)
   Text(1,25,"Controls")
   Pen(Black)
   Line(25,36,54,36)
   Line(25,18,52,18)
   Line(52,-18,25,-18)
   Line(25,-36,52,-36)
   }


  Page(B/A3,Landscape,16,[597,467],100)
   {
   -Sticky-([72,612],0)
    {
    Name = ""
    Font = 1
    Bounds = 72,612,180,648
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "FAULT CONTROLS"
    }
   -Wire-([648,684],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([684,684],0,0,-1)
    {
    Name = "Tfs"
    }
   0.datalabel([684,720],0,0,-1)
    {
    Name = "Tfd"
    }
   0.datalabel([1944,1512],4,0,-1)
    {
    Name = "Fault"
    }
   -Wire-([1944,1512],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -ControlPanel-([18,396],0)
    {
    Name = "SOURCE 2"
    Flags = 0
    State = 1
    Icon = -1,-1
    Posn = -1,-1
    Extents = 0,0,576,126
    Slider(39565784)
    Meter(39608872)
    Slider(39562744)
    Meter(39507840)
    Meter(39349104)
    Meter(39376432)
    Meter(39485936)
    Meter(39488848)
    }
   -Sticky-([522,108],0)
    {
    Name = "Untitled"
    Font = 1
    Bounds = 522,108,684,216
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "\
Adjust phase angle to obtain
the correct power flow. Adjust
voltage to obtain the matching
VAR flow at each end."
    }
   0.arrow_a([522,216],1,0,-1)
    {
    }
   0.datalabel([1674,702],3,0,-1)
    {
    Name = "B3T1"
    }
   0.datalabel([1674,756],3,0,-1)
    {
    Name = "B3T2"
    }
   0.datalabel([1674,810],3,0,-1)
    {
    Name = "B4T1"
    }
   0.datalabel([1980,1332],6,0,-1)
    {
    Name = "B1"
    }
   0.datalabel([1980,1350],6,0,-1)
    {
    Name = "B2"
    }
   0.datalabel([1980,1368],6,0,-1)
    {
    Name = "B3"
    }
   0.datalabel([1980,1386],6,0,-1)
    {
    Name = "B4"
    }
   -Sticky-([1386,126],0)
    {
    Name = ""
    Font = 1
    Bounds = 1386,126,1494,162
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "BREAKER CONTROLS"
    }
   -Wire-([648,720],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -ControlPanel-([1404,234],0)
    {
    Name = "B1 Timing"
    Flags = 0
    State = 1
    Icon = -1,-1
    Posn = -1,-1
    Extents = 0,0,216,126
    Switch(38449936)
    Slider(38467352)
    Slider(38460656)
    }
   -ControlPanel-([1404,378],0)
    {
    Name = "B2 Timing"
    Flags = 0
    State = 1
    Icon = -1,-1
    Posn = -1,-1
    Extents = 0,0,216,126
    Switch(38453320)
    Slider(38463600)
    Slider(38482192)
    }
   0.datalabel([1674,864],3,0,-1)
    {
    Name = "B4T2"
    }
   -ControlPanel-([1404,756],0)
    {
    Name = "B4 Timing"
    Flags = 0
    State = 1
    Icon = -1,-1
    Posn = -1,-1
    Extents = 0,0,216,126
    Switch(38479128)
    Slider(38440664)
    Slider(38437512)
    }
   0.var([1638,864],0,38437512,190)
    {
    Name = "B4T2"
    Group = ""
    Display = "0"
    Max = "2.0"
    Min = "0.0"
    Value = "2.0"
    Units = "s"
    Collect = "1"
    }
   0.var([1638,810],0,38440664,160)
    {
    Name = "B4T1"
    Group = ""
    Display = "0"
    Max = "2.0"
    Min = "0.0"
    Value = "0.36"
    Units = "s"
    Collect = "1"
    }
   0.var([1638,756],0,38443520,150)
    {
    Name = "B3T2"
    Group = ""
    Display = "0"
    Max = "2.0"
    Min = "0.0"
    Value = "2.0"
    Units = "s"
    Collect = "1"
    }
   -Sticky-([18,198],0)
    {
    Name = ""
    Font = 1
    Bounds = 18,198,144,234
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "PREFAULT CONTROLS"
    }
   -Wire-([2124,504],0,0,-1)
    {
    Vertex="0,0;-18,0"
    }
   -Wire-([2124,324],0,0,-1)
    {
    Vertex="0,0;-18,0"
    }
   0.logic([2160,504],6,0,420)
    {
    Type = "1"
    Inv = "0"
    }
   0.logic([2160,324],0,0,530)
    {
    Type = "1"
    Inv = "0"
    }
   -Wire-([2196,324],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.var_switch([2196,288],0,38449936,20)
    {
    Name = "42-B1"
    Group = ""
    Display = "0"
    Value = "0"
    Max = "1"
    Min = "0"
    Ton = "O"
    Toff = "C"
    }
   -Wire-([2196,504],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.var_switch([2196,450],6,38453320,70)
    {
    Name = "42-B2"
    Group = ""
    Display = "0"
    Value = "0"
    Max = "1"
    Min = "0"
    Ton = "O"
    Toff = "C"
    }
   -Wire-([2232,468],0,0,-1)
    {
    Vertex="0,0;0,-18"
    }
   0.tbreakn([2070,324],4,0,390)
    {
    NUMS = "2"
    INIT = "0"
    TO1 = "B1T1"
    TO2 = "B1T2"
    }
   0.tbreakn([2070,504],4,0,80)
    {
    NUMS = "2"
    INIT = "0"
    TO1 = "B2T1"
    TO2 = "B2T2"
    }
   0.datalabel([1674,324],3,0,-1)
    {
    Name = "B1T1"
    }
   0.datalabel([1674,378],3,0,-1)
    {
    Name = "B1T2"
    }
   0.datalabel([1674,432],3,0,-1)
    {
    Name = "B2T1"
    }
   0.var([1638,378],0,38460656,30)
    {
    Name = "B1 T2"
    Group = ""
    Display = "0"
    Max = "2.0"
    Min = "0.0"
    Value = "2.0"
    Units = "s"
    Collect = "1"
    }
   0.var([1638,432],0,38463600,50)
    {
    Name = "B2 T1"
    Group = ""
    Display = "0"
    Max = "2.0"
    Min = "0.0"
    Value = "2.0"
    Units = "s"
    Collect = "1"
    }
   0.datalabel([1674,486],3,0,-1)
    {
    Name = "B2T2"
    }
   0.var([1638,324],0,38467352,10)
    {
    Name = "B1 T1"
    Group = ""
    Display = "0"
    Max = "2"
    Min = "0.0"
    Value = "2.0"
    Units = "s"
    Collect = "1"
    }
   -Wire-([1980,864],0,0,-1)
    {
    Vertex="0,0;-18,0"
    }
   -Wire-([1980,684],0,0,-1)
    {
    Vertex="0,0;-18,0"
    }
   -Wire-([1980,720],0,0,-1)
    {
    Vertex="0,0;0,108"
    }
   0.logic([2016,864],6,0,210)
    {
    Type = "1"
    Inv = "0"
    }
   -Wire-([2052,684],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.var_switch([2052,648],0,38472512,120)
    {
    Name = "42-B3"
    Group = ""
    Display = "0"
    Value = "0"
    Max = "1"
    Min = "0"
    Ton = "O"
    Toff = "C"
    }
   -Wire-([2052,864],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([2088,828],0,0,-1)
    {
    Vertex="0,0;0,-18"
    }
   0.var([1638,702],0,38476272,130)
    {
    Name = "B3T1"
    Group = ""
    Display = "0"
    Max = "2"
    Min = "0.0"
    Value = "0.32"
    Units = "s"
    Collect = "1"
    }
   0.var_switch([2052,810],6,38479128,180)
    {
    Name = "42-B4"
    Group = ""
    Display = "0"
    Value = "0"
    Max = "1"
    Min = "0"
    Ton = "O"
    Toff = "C"
    }
   -Sticky-([954,108],0)
    {
    Name = ""
    Font = 1
    Bounds = 954,108,1080,144
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "COMTRADE Recorders"
    }
   0.var([1638,486],0,38482192,60)
    {
    Name = "B2 T2"
    Group = ""
    Display = "0"
    Max = "2.0"
    Min = "0.0"
    Value = "2.0"
    Units = "s"
    Collect = "1"
    }
   0.const([900,1458],0,0,320)
    {
    Name = ""
    Value = "360"
    }
   -Wire-([1314,1224],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([1350,1224],0,0,-1)
    {
    Name = "TPROT"
    }
   -Wire-([810,1224],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([846,1224],0,0,-1)
    {
    Name = "TStart"
    }
   -Wire-([846,1422],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Wire-([972,1422],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   -Wire-([1062,1422],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([432,1278],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   -Wire-([666,1278],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   -Wire-([756,1278],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   -Wire-([1260,1278],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   0.var([774,1224],0,38492176,240)
    {
    Name = "StartTime"
    Group = ""
    Display = "0"
    Max = "1.0"
    Min = "0.0"
    Value = "0.2"
    Units = "s"
    Collect = "1"
    }
   0.div([1026,1422],0,0,580)
    {
    }
   0.var([1278,1224],0,38495416,280)
    {
    Name = "Prot Time"
    Group = ""
    Display = "0"
    Max = "0.1"
    Min = "0.0"
    Value = "0.032"
    Units = "s"
    Collect = "1"
    }
   0.mult([720,1278],0,0,470)
    {
    }
   0.Sequencer_Wait([828,1278],0,0,480)
    {
    WaitType = "2"
    CrossDir = "1"
    FixedDelay = "1.0 [s]"
    Min = "0.0 [s]"
    Max = "1.0 [s]"
    UntilTime = "TStart"
    CrossValue = "0.0"
    CrossSig = "Va"
    State = "0"
    }
   -Wire-([990,1278],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   -Wire-([1116,1278],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   0.const([990,1458],0,0,330)
    {
    Name = "FREQ"
    Value = "$(f)"
    }
   -Wire-([1260,1278],0,0,-1)
    {
    Vertex="0,0;-18,0"
    }
   0.Sequencer_Wait([1332,1278],0,0,610)
    {
    WaitType = "0"
    CrossDir = "1"
    FixedDelay = "TPROT"
    Min = "0.0 [s]"
    Max = "1.0 [s]"
    UntilTime = "1.0 [s]"
    CrossValue = "0.0"
    CrossSig = "Va"
    State = "0"
    }
   -Wire-([1512,1278],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   -Wire-([1512,1278],0,0,-1)
    {
    Vertex="0,0;-18,0"
    }
   -Wire-([1566,1224],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([1602,1224],0,0,-1)
    {
    Name = "Tdelay"
    }
   0.var([1530,1224],0,38506040,290)
    {
    Name = "Prot Delay"
    Group = ""
    Display = "0"
    Max = "0.1"
    Min = "0.0"
    Value = "0.014"
    Units = "s"
    Collect = "1"
    }
   0.Sequencer_Wait([936,1278],0,0,490)
    {
    WaitType = "3"
    CrossDir = "1"
    FixedDelay = "1.0 [s]"
    Min = "0.0 [s]"
    Max = "1.0 [s]"
    UntilTime = "TStart"
    CrossValue = "0.0"
    CrossSig = "V1a"
    State = "0"
    }
   0.Sequencer_Wait([1062,1278],0,0,590)
    {
    WaitType = "0"
    CrossDir = "1"
    FixedDelay = "FDelay"
    Min = "0.0 [s]"
    Max = "1.0 [s]"
    UntilTime = "TStart"
    CrossValue = "0.0"
    CrossSig = "Va"
    State = "0"
    }
   0.Sequencer_Breaker([504,1278],0,0,260)
    {
    BNAME = "B3seq"
    OpenClos = "0"
    State = "1"
    }
   0.Sequencer_Breaker([612,1278],0,0,270)
    {
    BNAME = "B4seq"
    OpenClos = "0"
    State = "1"
    }
   -Wire-([432,864],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   0.var_pot([396,864],0,38513320,140)
    {
    Name = "Fault type"
    Group = ""
    Display = "0"
    NDP = "10"
    Value = "5"
    F1 = "1.0"
    F2 = "2.0"
    F3 = "3.0"
    F4 = "4.0"
    F5 = "5.0"
    F6 = "6.0"
    F7 = "7.0"
    F8 = "8.0"
    F9 = "9.0"
    F10 = "0"
    }
   -Wire-([432,936],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   0.var_pot([396,936],0,38516768,170)
    {
    Name = "Fault Location "
    Group = ""
    Display = "0"
    NDP = "6"
    Value = "5"
    F1 = "1.0"
    F2 = "2.0"
    F3 = "3.0"
    F4 = "4.0"
    F5 = "5.0"
    F6 = "6.0"
    F7 = "7.0"
    F8 = "8.0"
    F9 = "9.0"
    F10 = "10.0"
    }
   0.export([2034,1512],4,0,700)
    {
    Name = "F"
    }
   0.export([2034,1458],4,0,710)
    {
    Name = "B"
    }
   -Wire-([1908,1404],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   0.datalabel([504,936],0,0,-1)
    {
    Name = "Faultloc"
    }
   0.datalabel([1944,1422],0,0,-1)
    {
    Name = "Faultloc"
    }
   -Wire-([1944,1422],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.var_switch([684,1368],0,38524080,300)
    {
    Name = "Seq. Enable"
    Group = ""
    Display = "0"
    Value = "1"
    Max = "1"
    Min = "0"
    Ton = "Enab"
    Toff = "Off"
    }
   -Wire-([720,1314],0,0,-1)
    {
    Vertex="0,0;0,54"
    }
   0.logic([2016,684],0,0,440)
    {
    Type = "1"
    Inv = "0"
    }
   0.datalabel([720,1350],3,0,-1)
    {
    Name = "Seq_enable"
    }
   -Wire-([2124,360],0,0,-1)
    {
    Vertex="0,0;0,108"
    }
   0.div([936,1422],0,0,570)
    {
    }
   -Wire-([414,1278],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   0.Sequencer_Start([360,1278],0,0,250)
    {
    loop = "0"
    State = "1"
    }
   0.consti([1980,1008],0,0,220)
    {
    Name = ""
    Value = "1"
    }
   0.datalabel([2232,1422],0,0,-1)
    {
    Name = "V1a"
    }
   0.datatap([2268,1422],0,0,370)
    {
    Index = "2"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.datalabel([2268,1422],0,0,-1)
    {
    Name = "V1B"
    }
   0.datalabel([2304,1422],0,0,-1)
    {
    Name = "V1c"
    }
   0.datalabel([1098,1422],0,0,-1)
    {
    Name = "FDelay"
    }
   0.var([702,1422],0,38536360,310)
    {
    Name = "FaultAngle"
    Group = ""
    Display = "0"
    Max = "360"
    Min = "0.0"
    Value = "30.0"
    Units = "deg"
    Collect = "1"
    }
   -Wire-([738,1422],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([774,1422],0,0,-1)
    {
    Name = "FAngle"
    }
   0.datalabel([846,1422],0,0,-1)
    {
    Name = "FAngle1"
    }
   0.datalabel([2070,1044],0,0,-1)
    {
    Name = "FAngle1"
    }
   0.datalabel([1962,1116],0,0,-1)
    {
    Name = "V1c"
    }
   0.datalabel([1962,1080],0,0,-1)
    {
    Name = "V1B"
    }
   0.datalabel([1962,1044],0,0,-1)
    {
    Name = "V1a"
    }
   0.datalabel([1962,1188],0,0,-1)
    {
    Name = "I3B"
    }
   0.import([2142,1368],0,0,340)
    {
    Name = "I"
    }
   0.datatap([2232,1350],3,0,500)
    {
    Index = "3"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.datalabel([2232,1350],2,0,-1)
    {
    Name = "I3c"
    }
   0.datatap([2268,1350],3,0,510)
    {
    Index = "2"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.datatap([2304,1350],3,0,520)
    {
    Index = "1"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.datalabel([2304,1350],2,0,-1)
    {
    Name = "I3a"
    }
   0.datalabel([1962,1152],0,0,-1)
    {
    Name = "I3a"
    }
   0.datalabel([2268,1350],2,0,-1)
    {
    Name = "I3B"
    }
   0.datalabel([1962,1224],0,0,-1)
    {
    Name = "I3c"
    }
   0.tbreakn([1926,864],4,0,200)
    {
    NUMS = "2"
    INIT = "0"
    TO1 = "B4T1"
    TO2 = "B4T2"
    }
   0.import([1800,414],0,0,40)
    {
    Name = "Flt_en"
    }
   0.var([612,720],0,38555176,100)
    {
    Name = "Duration "
    Group = ""
    Display = "0"
    Max = "1.0"
    Min = "0.0"
    Value = "0.2"
    Units = ""
    Collect = "1"
    }
   0.var([612,684],0,38558024,90)
    {
    Name = "Fault Start "
    Group = ""
    Display = "0"
    Max = "1.0"
    Min = "0.0"
    Value = "0.3"
    Units = "s"
    Collect = "1"
    }
   -Sticky-([54,792],0)
    {
    Name = "Untitled"
    Font = 1
    Bounds = 54,792,198,1098
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "\
Dial Position:
  1=> FT1:
          Between Source
          and  B1
  2=> FT2: 
          Between B1 
          and Line
  3=> FT3: 
          Between Line 1
          and B2
  4=> FT4: 
          Between Source
          and B2
  5=> FT5:
          Between B3
          and Line 2
  6=> FT6:
          Between Line 2 
          and B4  "
    }
   -Sticky-([216,792],0)
    {
    Name = "Untitled"
    Font = 1
    Bounds = 216,792,324,990
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "\
Dial Position:
  1=> A-g
  2=> B-g
  3=> C-g
  4=> AB-g
  5=> AC-g
  6=> BC-g
  7=> ABC-g
  8=> AB 
  9=> AC 
10=> no  fault
11=> No fault (0)"
    }
   -ControlPanel-([1404,612],0)
    {
    Name = "B3 Timing"
    Flags = 0
    State = 1
    Icon = -1,-1
    Posn = -1,-1
    Extents = 0,0,216,126
    Switch(38472512)
    Slider(38476272)
    Slider(38443520)
    }
   -ControlPanel-([954,162],0)
    {
    Name = "Recorders"
    Flags = 0
    State = 1
    Icon = -1,-1
    Posn = -1,-1
    Extents = 0,0,144,126
    Slider(39664168)
    Slider(39661128)
    }
   -ControlPanel-([882,324],0)
    {
    Name = "Recorder Control"
    Flags = 0
    State = 1
    Icon = -1,-1
    Posn = -1,-1
    Extents = 0,0,288,126
    Switch(39676792)
    Switch(39679456)
    Switch(39682176)
    Switch(39684896)
    }
   -Sticky-([900,468],0)
    {
    Name = ""
    Font = 1
    Bounds = 900,468,1170,576
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "\
To turn the Recorders on, click on the switch.
On = Recorder will record data.
Off = Recorder will NOT record data.

You can turn on or off each recorder individually.      "
    }
   0.datalabel([1044,738],0,0,-1)
    {
    Name = "Seq_enable"
    }
   -Wire-([936,666],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   -Wire-([1080,702],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([1116,702],2,0,-1)
    {
    Name = "Fault"
    }
   -Wire-([936,702],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   0.datalabel([936,702],4,0,-1)
    {
    Name = "Fault1"
    }
   0.datalabel([936,666],2,0,-1)
    {
    Name = "Faultseq"
    }
   0.datalabel([2304,828],2,0,-1)
    {
    Name = "B4"
    }
   -Wire-([2160,828],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([2232,792],2,0,-1)
    {
    Name = "Seq_enable"
    }
   -Wire-([2196,864],0,0,-1)
    {
    Vertex="0,0;0,36"
    }
   0.datalabel([2196,900],0,0,-1)
    {
    Name = "B4seq"
    }
   -Wire-([2268,828],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1836,774],0,0,-1)
    {
    Vertex="0,0;144,0"
    }
   0.logic([2124,828],0,0,460)
    {
    Type = "2"
    Inv = "0"
    }
   0.tbreakn([1926,684],4,0,430)
    {
    NUMS = "2"
    INIT = "0"
    TO1 = "B3T1"
    TO2 = "B3T2"
    }
   0.select([2232,828],6,0,660)
    {
    A = "1"
    DPath = "1"
    COM = "Selector"
    }
   -Wire-([2160,684],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([2232,720],4,0,-1)
    {
    Name = "Seq_enable"
    }
   -Wire-([2196,648],0,0,-1)
    {
    Vertex="0,0;0,-36"
    }
   -Wire-([2268,684],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1836,414],0,0,-1)
    {
    Vertex="0,0;0,360"
    }
   0.logic([2124,684],6,0,450)
    {
    Type = "2"
    Inv = "0"
    }
   0.select([2232,684],0,0,670)
    {
    A = "1"
    DPath = "1"
    COM = "Selector"
    }
   0.datalabel([2304,684],4,0,-1)
    {
    Name = "B3"
    }
   0.datalabel([2196,612],6,0,-1)
    {
    Name = "B3seq"
    }
   0.Sequencer_Breaker([1440,1278],0,0,620)
    {
    BNAME = "B3seq"
    OpenClos = "1"
    State = "0"
    }
   0.Sequencer_Breaker([1692,1278],0,0,640)
    {
    BNAME = "B4seq"
    OpenClos = "1"
    State = "0"
    }
   -Wire-([2304,468],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.logic([2268,324],6,0,540)
    {
    Type = "2"
    Inv = "0"
    }
   -Wire-([2304,324],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([2340,468],2,0,-1)
    {
    Name = "B2"
    }
   0.datalabel([2340,324],4,0,-1)
    {
    Name = "B1"
    }
   0.logic([2268,468],0,0,550)
    {
    Type = "2"
    Inv = "0"
    }
   0.logic([2052,378],0,0,410)
    {
    Type = "1"
    Inv = "0"
    }
   0.inv([1980,378],0,0,400)
    {
    INTR = "0"
    }
   -Wire-([1980,378],0,0,-1)
    {
    Vertex="0,0;-72,0"
    }
   0.datalabel([1908,378],2,0,-1)
    {
    Name = "Seq_enable"
    }
   -Wire-([1836,414],0,0,-1)
    {
    Vertex="0,0;180,0"
    }
   -Wire-([2088,378],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Sticky-([1530,126],0)
    {
    Name = "Untitled"
    Font = 1
    Bounds = 1530,126,1692,198
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "\
Adjust breaker clearing time (T1)
and reclose time (T2) if needed."
    }
   -Sticky-([1764,108],0)
    {
    Name = ""
    Font = 1
    Bounds = 1764,108,1980,306
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "\
Note:
There is no control for B1 and B2
by the sequencer.  

To add it in, remove the Seq_enable 
signal and AND gate.

Add a switch, similar to B3 and B4.

Add in the control component in the 
sequencer line, similar to B3 and B4."
    }
   -Wire-([2178,1368],0,0,-1)
    {
    Vertex="0,0;108,0"
    }
   0.datatap([2304,1422],0,0,380)
    {
    Index = "3"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   -Wire-([2178,1404],0,0,-1)
    {
    Vertex="0,0;108,0"
    }
   0.import([2142,1404],0,0,350)
    {
    Name = "V"
    }
   0.datatap([2232,1422],0,0,360)
    {
    Index = "1"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.datamerge([1998,1404],4,0,680)
    {
    N = "6"
    Type = "1"
    Disp = "1"
    }
   -Sticky-([1908,1278],0)
    {
    Name = ""
    Font = 1
    Bounds = 1908,1278,2016,1314
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "Exports to Main Page"
    }
   -Sticky-([2124,1278],0)
    {
    Name = ""
    Font = 1
    Bounds = 2124,1278,2250,1314
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "\
Imports from Main Page
"
    }
   0.tfaultn([900,702],4,0,110)
    {
    TF = "Tfs"
    DF = "Tfd"
    }
   0.select([1044,702],0,0,690)
    {
    A = "1"
    DPath = "1"
    COM = "Selector"
    }
   0.select([1638,1044],0,0,650)
    {
    A = "1"
    DPath = "1"
    COM = "Selector"
    }
   0.datalabel([1908,1404],0,0,-1)
    {
    Name = "FType"
    }
   0.datalabel([1746,1044],0,0,-1)
    {
    Name = "FType"
    }
   0.datalabel([2070,1080],0,0,-1)
    {
    Name = "FaultType"
    }
   0.datalabel([504,864],0,0,-1)
    {
    Name = "FaultType1"
    }
   0.datalabel([1548,1044],0,0,-1)
    {
    Name = "FaultType1"
    }
   -Wire-([1674,1044],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   0.datalabel([1548,1008],0,0,-1)
    {
    Name = "FaultType"
    }
   -Wire-([1548,1008],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Wire-([1548,1044],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   0.var_switch([1638,1116],3,38662232,230)
    {
    Name = "MREnable"
    Group = ""
    Display = "0"
    Value = "1"
    Max = "1"
    Min = "0"
    Ton = "ON"
    Toff = "OFF"
    }
   -ControlPanel-([1404,954],0)
    {
    Name = "MR Enable"
    Flags = 0
    State = 1
    Icon = -1,-1
    Posn = -1,-1
    Extents = 0,0,72,126
    Switch(38662232)
    }
   0.pgb([1926,1404],3,38672416,720)
    {
    Name = "Ftype"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "1"
    Max = "11"
    }
   0.Sequencer_Fault([1188,1278],0,0,600)
    {
    FNAME = "Faultseq"
    AppRem = "1"
    State = "0"
    }
   -Sticky-([1098,954],0)
    {
    Name = ""
    Font = 1
    Bounds = 1098,954,1314,1116
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "\
When the Multiple Run component
is disabled, you must turn this dial to
\"OFF\".  This enables you to control
the fault location using the Fault
Location Dial.
This dial does NOT control the 
multiple run component.

See Chapter 5.2 for more information."
    }
   0.Sequencer_Wait([1584,1278],0,0,630)
    {
    WaitType = "0"
    CrossDir = "1"
    FixedDelay = "TDELAY"
    Min = "0.0 [s]"
    Max = "1.0 [s]"
    UntilTime = "1.0 [s]"
    CrossValue = "0.0"
    CrossSig = "Va"
    State = "0"
    }
   0.mrun([2016,1080],0,0,560)
    {
    NV = "2"
    VType1 = "0"
    IType1 = "1"
    VType2 = "2"
    IType2 = "0"
    VType3 = "0"
    IType3 = "1"
    VType4 = "0"
    IType4 = "1"
    VType5 = "0"
    IType5 = "1"
    VType6 = "0"
    IType6 = "1"
    V1Label = "Fault Angle"
    V2Label = "Fault type"
    ENAB = "1"
    V3Label = "Var # 3"
    V4Label = "Var # 4"
    V5Label = "Var # 5"
    V6Label = "Var # 6"
    STDEV = "2.0"
    V1DR = "0.0"
    V2DR = "0.0"
    V3DR = "0.0"
    V4DR = "0.0"
    V5DR = "0.0"
    V6DR = "0.0"
    V1DI = "0"
    V2DI = "0"
    V3DI = "0"
    V4DI = "0"
    V5DI = "0"
    V6DI = "0"
    N1R = "10"
    Min1R = "0.0"
    Inc1R = "60"
    Max1R = "300"
    V1Run1R = "1"
    V1Run6R = "6"
    V1Run2R = "2"
    V1Run7R = "7"
    V1Run3R = "3"
    V1Run8R = "8"
    V1Run4R = "4"
    V1Run9R = "9"
    V1Run5R = "5"
    V1Run10R = "10"
    N1I = "10"
    Min1I = "0"
    Inc1I = "1"
    Max1I = "10"
    V1Run1I = "1"
    V1Run6I = "6"
    V1Run2I = "2"
    V1Run7I = "7"
    V1Run3I = "3"
    V1Run8I = "8"
    V1Run4I = "4"
    V1Run9I = "9"
    V1Run5I = "5"
    V1Run10I = "10"
    N2R = "10"
    Min2R = "0.0"
    Inc2R = "1.0"
    Max2R = "1.0"
    V2Run1R = "1"
    V2Run6R = "6"
    V2Run2R = "2"
    V2Run7R = "7"
    V2Run3R = "3"
    V2Run8R = "8"
    V2Run4R = "4"
    V2Run9R = "9"
    V2Run5R = "5"
    V2Run10R = "10"
    N2I = "2"
    Min2I = "0"
    Inc2I = "1"
    Max2I = "10"
    V2Run1I = "1"
    V2Run6I = "6"
    V2Run2I = "7"
    V2Run7I = "7"
    V2Run3I = "4"
    V2Run8I = "8"
    V2Run4I = "4"
    V2Run9I = "9"
    V2Run5I = "7"
    V2Run10I = "10"
    N3R = "10"
    Min3R = "0.0"
    Inc3R = "1.0"
    Max3R = "1.0"
    V3Run1R = "1"
    V3Run6R = "6"
    V3Run2R = "2"
    V3Run7R = "7"
    V3Run3R = "3"
    V3Run8R = "8"
    V3Run4R = "4"
    V3Run9R = "9"
    V3Run5R = "5"
    V3Run10R = "10"
    N3I = "10"
    Min3I = "0"
    Inc3I = "1"
    Max3I = "10"
    V3Run1I = "1"
    V3Run6I = "6"
    V3Run2I = "2"
    V3Run7I = "7"
    V3Run3I = "3"
    V3Run8I = "8"
    V3Run4I = "4"
    V3Run9I = "9"
    V3Run5I = "5"
    V3Run10I = "10"
    N4R = "10"
    Min4R = "0.0"
    Inc4R = "1.0"
    Max4R = "1.0"
    V4Run1R = "1"
    V4Run6R = "6"
    V4Run2R = "2"
    V4Run7R = "7"
    V4Run3R = "3"
    V4Run8R = "8"
    V4Run4R = "4"
    V4Run9R = "9"
    V4Run5R = "5"
    V4Run10R = "10"
    N4I = "10"
    Min4I = "0"
    Inc4I = "1"
    Max4I = "0"
    V4Run1I = "1"
    V4Run6I = "6"
    V4Run2I = "2"
    V4Run7I = "7"
    V4Run3I = "3"
    V4Run8I = "8"
    V4Run4I = "4"
    V4Run9I = "9"
    V4Run5I = "5"
    V4Run10I = "10"
    N5R = "10"
    Min5R = "0.0"
    Inc5R = "1.0"
    Max5R = "1.0"
    V5Run1R = "1"
    V5Run6R = "6"
    V5Run2R = "2"
    V5Run7R = "7"
    V5Run3R = "3"
    V5Run8R = "8"
    V5Run4R = "4"
    V5Run9R = "9"
    V5Run5R = "5"
    V5Run10R = "10"
    N5I = "10"
    Min5I = "0"
    Inc5I = "1"
    Max5I = "10"
    V5Run1I = "1"
    V5Run6I = "6"
    V5Run2I = "2"
    V5Run7I = "7"
    V5Run3I = "3"
    V5Run8I = "8"
    V5Run4I = "4"
    V5Run9I = "9"
    V5Run5I = "5"
    V5Run10I = "10"
    N6R = "10"
    Min6R = "0.0"
    Inc6R = "1.0"
    Max6R = "1.0"
    V6Run1R = "1"
    V6Run6R = "6"
    V6Run2R = "2"
    V6Run7R = "7"
    V6Run3R = "3"
    V6Run8R = "8"
    V6Run4R = "4"
    V6Run9R = "9"
    V6Run5R = "5"
    V6Run10R = "10"
    N6I = "10"
    Min6I = "0"
    Inc6I = "1"
    Max6I = "10"
    V6Run1I = "1"
    V6Run6I = "6"
    V6Run2I = "2"
    V6Run7I = "7"
    V6Run3I = "3"
    V6Run8I = "8"
    V6Run4I = "4"
    V6Run9I = "9"
    V6Run5I = "5"
    V6Run10I = "10"
    NM = "6"
    OUTNAM = "Data.out"
    Repeat = "1"
    Opt = "2"
    MinMax = "1"
    NDIV = "10"
    MType1 = "2"
    MType2 = "2"
    MType3 = "2"
    MType4 = "2"
    MType5 = "2"
    MType6 = "2"
    RType1 = "3"
    O1Label = "V1A"
    RType2 = "3"
    O2Label = "V1B"
    RType3 = "3"
    O3Label = "V1C"
    RType4 = "3"
    O4Label = "I3A"
    RType5 = "3"
    O5Label = "I3B"
    RType6 = "3"
    O6Label = "I3C"
    }
   -ControlPanel-([54,648],0)
    {
    Name = "Fault Location, Type, Start & Duration"
    Flags = 0
    State = 1
    Icon = -1,-1
    Posn = -1,-1
    Extents = 0,0,432,126
    Dial(38516768)
    Dial(38513320)
    Slider(38558024)
    Slider(38555176)
    Slider(39634808)
    }
   -ControlPanel-([684,954],0)
    {
    Name = "Sequence Control "
    Flags = 0
    State = 1
    Icon = -1,-1
    Posn = -1,-1
    Extents = 0,0,360,126
    Slider(38492176)
    Switch(38524080)
    Slider(38536360)
    Slider(38495416)
    Slider(38506040)
    }
   -ControlPanel-([18,252],0)
    {
    Name = "SOURCE 1"
    Flags = 0
    State = 1
    Icon = -1,-1
    Posn = -1,-1
    Extents = 0,0,576,126
    Slider(39556264)
    Meter(39603040)
    Slider(39559544)
    Meter(39504928)
    Meter(39516608)
    Meter(39614616)
    Meter(39546448)
    Meter(39483024)
    }
   -SrcFile-([2142,1026],0)
    {
   Name = "case3_Multi_run_global.emt\\Data.out"
    }
   -Divider-([1278,90],0)
    {
    Size(0,846)
    3D = 1
    Color = 9
    Style = 0
    Weight = 2
    }
   -Divider-([1278,936],0)
    {
    Size(1116,0)
    3D = 1
    Color = 9
    Style = 0
    Weight = 2
    }
   -Divider-([18,594],0)
    {
    Size(1260,0)
    3D = 1
    Color = 9
    Style = 0
    Weight = 2
    }
   -Divider-([810,90],0)
    {
    Size(0,504)
    3D = 1
    Color = 9
    Style = 0
    Weight = 2
    }
   }
  }
 Module("Plots_B1")
  {
  Desc = ""
  FileDate = 1144770342
  Nodes = 
   {
   }

  Graphics = 
   {
   Brush(Solid,Yellow)
   Rectangle(-24,-43,27,30)
   Line(-13,-1,-13,-21)
   Line(-18,-4,21,-4)
   Line(-13,-4,-4,-13)
   Line(-4,-13,1,-10)
   Line(6,-16,12,-13)
   Pen(Gray)
   Line(27,28,27,-43)
   Pen(Black)
   Line(1,-10,6,-16)
   Text(1,-28,"Plots")
   Text(3,24,"B1 B3")
   }


  Page(A/A4,Landscape,16,[597,467],100)
   {
   -Plot-([18,18],0)
    {
    Title = "Plots at B1"
    Draw = 1
    Area = [0,0,756,1170]
    Posn = [18,18]
    Icon = [-1,-1]
    Extents = 0,0,756,1170
    XLabel = ""
    AutoPan = "false,75"
    Graph([0,0],[0,0,756,282],"Voltage")
     {
     Options = 9
     Units = ""
     Curve(39501960,"V1a",0,,,)
     Curve(39327760,"V1b",1,,,)
     Curve(39311496,"V1c",2,,,)
     }
    Graph([0,282],[0,0,756,281],"Current")
     {
     Options = 9
     Units = ""
     Curve(39379416,"I1a",0,,,)
     Curve(39395672,"I1b",1,,,)
     Curve(39382496,"I1c",2,,,)
     }
    Graph([0,563],[0,0,756,281],"Current")
     {
     Options = 9
     Units = ""
     Curve(39386176,"I10",0,,,)
     }
    PGraph([0,844],[0,0,756,263],"PolyGraph")
     {
     Options = 2
     Curve(39319736,"Br1a",0,,,)
     Curve(39330536,"Br1b",1,,,)
     Curve(39371672,"Br1c",2,,,)
     }
    }
   -Plot-([810,18],0)
    {
    Title = "Plots at B3"
    Draw = 1
    Area = [0,0,756,1170]
    Posn = [810,18]
    Icon = [-1,-1]
    Extents = 0,0,756,1170
    XLabel = ""
    AutoPan = "false,75"
    Graph([0,0],[0,0,756,282],"Voltage")
     {
     Options = 9
     Units = ""
     Curve(39439512,"V3a",0,,,)
     Curve(39442288,"V3b",1,,,)
     Curve(39445368,"V3c",2,,,)
     }
    Graph([0,282],[0,0,756,281],"Current")
     {
     Options = 9
     Units = ""
     Curve(39448280,"I3a",0,,,)
     Curve(39451192,"I3b",1,,,)
     Curve(39454104,"I3c",2,,,)
     }
    Graph([0,563],[0,0,756,281],"Current")
     {
     Options = 9
     Units = ""
     Curve(39457016,"I30",0,,,)
     }
    PGraph([0,844],[0,0,756,263],"PolyGraph")
     {
     Options = 2
     Curve(39474776,"Br3a",0,,,1)
     Curve(39477552,"Br3b",1,,,1)
     Curve(39480328,"Br3c",2,,,1)
     }
    }
   }
  }
 Module("Plots_B2")
  {
  Desc = ""
  FileDate = 0
  Nodes = 
   {
   }

  Graphics = 
   {
   Brush(Solid,Yellow)
   Rectangle(-24,-43,27,30)
   Line(-13,-1,-13,-21)
   Line(-13,-4,-4,-13)
   Line(-4,-13,1,-10)
   Line(6,-16,12,-13)
   Pen(Gray)
   Line(27,28,27,-43)
   Pen(Black)
   Line(1,-10,6,-16)
   Line(-18,-4,21,-4)
   Text(1,-28,"Plots")
   Text(3,24,"B2 B4")
   }


  Page(A/A4,Landscape,16,[597,467],100)
   {
   -Plot-([18,18],0)
    {
    Title = "Plots at B2"
    Draw = 1
    Area = [0,0,756,1170]
    Posn = [18,18]
    Icon = [-1,-1]
    Extents = 0,0,756,1170
    XLabel = ""
    AutoPan = "false,75"
    Graph([0,0],[0,0,756,282],"Voltage")
     {
     Options = 9
     Units = ""
     Curve(39630304,"V2a",0,,,)
     Curve(39314408,"V2b",1,,,)
     Curve(39341432,"V2c",2,,,)
     }
    Graph([0,282],[0,0,756,281],"Current")
     {
     Options = 9
     Units = ""
     Curve(39305616,"I2a",0,,,)
     Curve(39308584,"I2b",1,,,)
     Curve(39392760,"I2c",2,,,)
     }
    Graph([0,563],[0,0,756,281],"Current")
     {
     Options = 9
     Units = ""
     Curve(39389984,"I20",0,,,)
     }
    PGraph([0,844],[0,0,756,263],"PolyGraph")
     {
     Options = 2
     Curve(39627640,"Br2a",0,,,)
     Curve(39333312,"Br2b",1,,,)
     Curve(39324032,"Br2c",2,,,)
     }
    }
   -Plot-([792,18],0)
    {
    Title = "Plots at B4"
    Draw = 1
    Area = [0,0,756,1170]
    Posn = [792,18]
    Icon = [-1,-1]
    Extents = 0,0,756,1170
    XLabel = ""
    AutoPan = "false,75"
    Graph([0,0],[0,0,756,282],"Voltage")
     {
     Options = 9
     Units = ""
     Curve(39624728,"V4a",0,,,)
     Curve(39459928,"V4b",1,,,)
     Curve(39513528,"V4c",2,,,)
     }
    Graph([0,282],[0,0,756,281],"Current")
     {
     Options = 9
     Units = ""
     Curve(39462840,"I4a",0,,,)
     Curve(39465752,"I4b",1,,,)
     Curve(39468664,"I4c",2,,,)
     }
    Graph([0,563],[0,0,756,281],"Current")
     {
     Options = 9
     Units = ""
     Curve(39471752,"I40",0,,,)
     }
    PGraph([0,844],[0,0,756,263],"PolyGraph")
     {
     Options = 2
     Curve(39242944,"Br4a",0,,,)
     Curve(39491760,"Br4b",1,,,)
     Curve(39494536,"Br4c",2,,,)
     }
    }
   }
  }
 Module("Main")
  {
  Desc = "Main Page"
  FileDate = 1144770342
  Nodes = 
   {
   }

  Graphics = 
   {
   Rectangle(-18,-18,18,18)
   }


  Page(B/A3,Landscape,16,[597,467],100)
   {
   0.pgb([1800,1242],0,39242944,1100)
    {
    Name = "Br4a"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-1.0"
    Max = "1.0"
    }
   0.datalabel([2034,180],2,0,-1)
    {
    Name = "I1A"
    }
   0.datalabel([2070,180],2,0,-1)
    {
    Name = "I1B"
    }
   0.datalabel([2106,180],2,0,-1)
    {
    Name = "I1C"
    }
   0.datalabel([2034,360],2,0,-1)
    {
    Name = "I2A"
    }
   0.datalabel([2070,360],2,0,-1)
    {
    Name = "I2B"
    }
   0.datalabel([2106,360],2,0,-1)
    {
    Name = "I2C"
    }
   -Wire-([1368,1206],0,0,-1)
    {
    Vertex="0,0;0,90"
    }
   0.datatap([1386,1242],0,0,300)
    {
    Index = "1"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.datatap([1386,1278],0,0,380)
    {
    Index = "2"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.datalabel([1926,180],2,0,-1)
    {
    Name = "V1A"
    }
   0.datalabel([1962,180],2,0,-1)
    {
    Name = "V1B"
    }
   0.datalabel([1998,180],2,0,-1)
    {
    Name = "V1C"
    }
   0.datalabel([1926,360],6,0,-1)
    {
    Name = "V2A"
    }
   0.datalabel([1962,360],6,0,-1)
    {
    Name = "V2B"
    }
   0.datalabel([1998,360],6,0,-1)
    {
    Name = "V2C"
    }
   -Wire-([1764,1404],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1764,1368],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1764,1314],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1764,1278],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1530,1440],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1530,1404],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1530,1368],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1404,1368],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1404,1404],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1404,1440],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1638,1242],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1638,1278],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1638,1314],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1638,1368],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1638,1404],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datatap([1512,1314],0,0,460)
    {
    Index = "3"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.datatap([1512,1278],0,0,410)
    {
    Index = "2"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   -Wire-([1512,1242],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Wire-([1512,1278],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Wire-([1512,1314],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Wire-([1386,1314],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Wire-([1386,1278],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Wire-([1386,1242],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   0.datatap([1386,1314],0,0,440)
    {
    Index = "3"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.datatap([1512,1242],0,0,330)
    {
    Index = "1"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   -Wire-([1494,1206],0,0,-1)
    {
    Vertex="0,0;0,90"
    }
   0.datalabel([432,1242],2,0,-1)
    {
    Name = "B2"
    }
   0.datalabel([108,1224],2,0,-1)
    {
    Name = "FT1"
    }
   0.datalabel([144,1224],2,0,-1)
    {
    Name = "FT2"
    }
   0.datalabel([180,1224],2,0,-1)
    {
    Name = "FT3"
    }
   -Wire-([162,1314],0,0,-1)
    {
    Vertex="0,0;0,72"
    }
   0.datalabel([144,1476],0,0,-1)
    {
    Name = "F2"
    }
   0.datalabel([180,1476],0,0,-1)
    {
    Name = "F3"
    }
   0.datalabel([198,1386],2,0,-1)
    {
    Name = "Fault"
    }
   -Wire-([1530,1476],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1404,1476],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([882,684],0,0,-1)
    {
    Vertex="0,0;0,18"
    }
   -Wire-([414,576],0,0,-1)
    {
    Vertex="0,0;0,90"
    }
   0.datalabel([432,684],0,0,-1)
    {
    Name = "FT1"
    }
   0.datalabel([432,702],0,0,-1)
    {
    Name = "F1"
    }
   0.pgb([1926,1314],0,39281144,490)
    {
    Name = "V3rms"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "220"
    Max = "250"
    }
   0.pgb([1926,1350],0,39284184,500)
    {
    Name = "V4rms"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "220"
    Max = "250"
    }
   0.datalabel([864,486],0,0,-1)
    {
    Name = "FT3"
    }
   0.datalabel([864,504],0,0,-1)
    {
    Name = "F3"
    }
   0.datalabel([864,720],0,0,-1)
    {
    Name = "FT6"
    }
   0.datalabel([864,738],0,0,-1)
    {
    Name = "F6"
    }
   0.datalabel([468,1242],2,0,-1)
    {
    Name = "B3"
    }
   0.datalabel([396,1242],2,0,-1)
    {
    Name = "B1"
    }
   0.datalabel([252,1224],2,0,-1)
    {
    Name = "FT5"
    }
   0.datalabel([288,1476],0,0,-1)
    {
    Name = "F6"
    }
   0.datalabel([648,486],0,0,-1)
    {
    Name = "FT2"
    }
   0.datalabel([648,504],0,0,-1)
    {
    Name = "F2"
    }
   0.datalabel([648,720],0,0,-1)
    {
    Name = "FT5"
    }
   -Wire-([630,684],0,0,-1)
    {
    Vertex="0,0;0,18"
    }
   0.breaker3([522,468],4,0,690)
    {
    Ctrl = "0"
    OPCUR = "0"
    ENAB = "0"
    CLVL = "0.0 [kA]"
    View = "1"
    ViewB = "1"
    DisPQ = "1"
    NAME = "B1"
    NAMEA = "BRKA"
    NAMEB = "BRKB"
    NAMEC = "BRKC"
    ROFF = "1.0e6 [ohm]"
    RON = "0.1 [ohm]"
    PRER = "0.5 [ohm]"
    TDA = "0.0 [s]"
    TDB = "0.0 [s]"
    TDC = "0.0 [s]"
    TDRA = "0.05 [s]"
    TDRB = "0.05 [s]"
    TDRC = "0.05 [s]"
    PostIns = "0"
    TDBOA = "0.005 [s]"
    IBRA = "I1A"
    IBRB = "I1B"
    IBRC = "I1C"
    IBR0 = "I10"
    SBRA = "Br1A"
    SBRB = "Br1B"
    SBRC = "Br1C"
    BP = "P1"
    BQ = "Q1"
    BOpen1 = "0"
    BOpen2 = "0"
    BOpen3 = "0"
    P = "-28.54 [MW]"
    Q = "2.791 [MVAR]"
    }
   -Wire-([594,468],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Wire-([1836,864],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Wire-([1872,468],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   -Wire-([1818,684],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   -Wire-([1872,720],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   0.datalabel([900,1368],0,0,-1)
    {
    Name = "I1A"
    }
   0.datalabel([900,1404],0,0,-1)
    {
    Name = "I1B"
    }
   0.datalabel([900,1440],0,0,-1)
    {
    Name = "I1C"
    }
   0.datalabel([1026,1368],0,0,-1)
    {
    Name = "I2A"
    }
   0.datalabel([1026,1404],0,0,-1)
    {
    Name = "I2B"
    }
   0.pgb([1062,1368],0,39305616,1040)
    {
    Name = "I2a"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "2.0"
    }
   0.pgb([1062,1404],0,39308584,920)
    {
    Name = "I2b"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "2.0"
    }
   0.pgb([936,1314],0,39311496,360)
    {
    Name = "V1c"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "-200.0"
    Max = "200.0"
    }
   0.pgb([1062,1278],0,39314408,310)
    {
    Name = "V2b"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "-150.0"
    Max = "150.0"
    }
   0.datalabel([1152,1242],0,0,-1)
    {
    Name = "Br1A"
    }
   0.datalabel([1152,1278],0,0,-1)
    {
    Name = "Br1B"
    }
   0.datalabel([1152,1314],0,0,-1)
    {
    Name = "Br1C"
    }
   0.pgb([1188,1242],0,39319736,1160)
    {
    Name = "Br1a"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-0.1"
    Max = "0.1"
    }
   0.datalabel([1278,1242],0,0,-1)
    {
    Name = "Br2A"
    }
   0.datalabel([1278,1278],0,0,-1)
    {
    Name = "Br2B"
    }
   0.pgb([1314,1314],0,39324032,1070)
    {
    Name = "Br2c"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-1.0"
    Max = "1.0"
    }
   0.datalabel([1152,1368],0,0,-1)
    {
    Name = "P1"
    }
   0.pgb([936,1278],0,39327760,280)
    {
    Name = "V1b"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "-200.0"
    Max = "200.0"
    }
   0.pgb([1188,1278],0,39330536,1130)
    {
    Name = "Br1b"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-0.1"
    Max = "0.1"
    }
   0.pgb([1314,1278],0,39333312,1110)
    {
    Name = "Br2b"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-1.0"
    Max = "1.0"
    }
   0.datatap([882,1242],0,0,230)
    {
    Index = "1"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.datatap([882,1278],0,0,270)
    {
    Index = "2"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.datalabel([864,1206],2,0,-1)
    {
    Name = "V1"
    }
   0.datalabel([900,1242],2,0,-1)
    {
    Name = "V1A"
    }
   0.datalabel([900,1278],2,0,-1)
    {
    Name = "V1B"
    }
   0.datalabel([1026,1278],2,0,-1)
    {
    Name = "V2B"
    }
   0.pgb([1062,1314],0,39341432,390)
    {
    Name = "V2c"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "-150.0"
    Max = "150.0"
    }
   -Wire-([1152,1440],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([1152,1440],0,0,-1)
    {
    Name = "S1W"
    }
   -Wire-([1152,1476],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([1152,1476],0,0,-1)
    {
    Name = "S1Q"
    }
   -Wire-([1278,1440],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1278,1476],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([1278,1476],0,0,-1)
    {
    Name = "S2Q"
    }
   0.datalabel([1026,1242],2,0,-1)
    {
    Name = "V2A"
    }
   0.pgb([1314,1368],0,39349104,950)
    {
    Name = "P2"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "MW"
    mrun = "0"
    Pol = "0"
    Min = "-150"
    Max = "150"
    }
   0.datalabel([1278,1440],0,0,-1)
    {
    Name = "S2W"
    }
   -Wire-([1278,1404],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([1278,1404],0,0,-1)
    {
    Name = "Q2"
    }
   -Wire-([1278,1368],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([1278,1368],0,0,-1)
    {
    Name = "P2"
    }
   -Wire-([1278,1314],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1278,1278],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1278,1242],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([1278,1314],0,0,-1)
    {
    Name = "Br2C"
    }
   0.datalabel([1026,1440],0,0,-1)
    {
    Name = "I2C"
    }
   -Wire-([1026,1440],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1026,1404],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1026,1368],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([900,1368],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([900,1404],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([900,1440],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1152,1242],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1152,1278],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1152,1314],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1152,1368],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1152,1404],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([1026,1314],2,0,-1)
    {
    Name = "V2C"
    }
   0.datatap([1008,1314],0,0,370)
    {
    Index = "3"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.datatap([1008,1278],0,0,290)
    {
    Index = "2"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   -Wire-([1008,1242],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Wire-([1008,1278],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Wire-([1008,1314],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   0.datalabel([900,1314],2,0,-1)
    {
    Name = "V1C"
    }
   -Wire-([882,1314],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Wire-([882,1278],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Wire-([882,1242],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   0.datatap([882,1314],0,0,350)
    {
    Index = "3"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.datalabel([1152,1404],0,0,-1)
    {
    Name = "Q1"
    }
   0.pgb([1188,1314],0,39371672,1090)
    {
    Name = "Br1c"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-0.1"
    Max = "0.1"
    }
   0.datatap([1008,1242],0,0,250)
    {
    Index = "1"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.datalabel([990,1206],2,0,-1)
    {
    Name = "V2"
    }
   -Wire-([990,1206],0,0,-1)
    {
    Vertex="0,0;0,90"
    }
   0.pgb([1314,1404],0,39376432,870)
    {
    Name = "Q2"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "MVAR"
    mrun = "0"
    Pol = "0"
    Min = "-50"
    Max = "50"
    }
   0.pgb([936,1368],0,39379416,1050)
    {
    Name = "I1a"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-1.5"
    Max = "1.5"
    }
   0.pgb([936,1440],0,39382496,880)
    {
    Name = "I1c"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-1.5"
    Max = "1.5"
    }
   -Wire-([1026,1476],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([900,1476],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.pgb([936,1476],0,39386176,800)
    {
    Name = "I10"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-0.4"
    Max = "0.4"
    }
   0.datalabel([1026,1476],0,0,-1)
    {
    Name = "I20"
    }
   0.pgb([1062,1476],0,39389984,770)
    {
    Name = "I20"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "2.0"
    }
   0.pgb([1062,1440],0,39392760,850)
    {
    Name = "I2c"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "2.0"
    }
   0.pgb([936,1404],0,39395672,960)
    {
    Name = "I1b"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-1.5"
    Max = "1.5"
    }
   -Wire-([864,1206],0,0,-1)
    {
    Vertex="0,0;0,90"
    }
   0.datalabel([900,1476],0,0,-1)
    {
    Name = "I10"
    }
   0.datalabel([1368,1206],2,0,-1)
    {
    Name = "V3"
    }
   0.datalabel([1404,1242],2,0,-1)
    {
    Name = "V3A"
    }
   0.datalabel([1404,1278],2,0,-1)
    {
    Name = "V3B"
    }
   0.datalabel([1404,1314],2,0,-1)
    {
    Name = "V3C"
    }
   0.datalabel([1530,1242],2,0,-1)
    {
    Name = "V4A"
    }
   0.datalabel([1530,1278],2,0,-1)
    {
    Name = "V4B"
    }
   0.datalabel([1530,1314],2,0,-1)
    {
    Name = "V4C"
    }
   0.datalabel([1926,612],2,0,-1)
    {
    Name = "V3A"
    }
   0.datalabel([1962,612],2,0,-1)
    {
    Name = "V3B"
    }
   0.datalabel([1998,612],2,0,-1)
    {
    Name = "V3C"
    }
   0.datalabel([1926,792],6,0,-1)
    {
    Name = "V4A"
    }
   0.datalabel([1962,792],6,0,-1)
    {
    Name = "V4B"
    }
   0.datalabel([1998,792],6,0,-1)
    {
    Name = "V4C"
    }
   0.datalabel([1404,1476],0,0,-1)
    {
    Name = "I30"
    }
   0.datalabel([1530,1368],0,0,-1)
    {
    Name = "I4A"
    }
   0.datalabel([1530,1404],0,0,-1)
    {
    Name = "I4B"
    }
   0.datalabel([1530,1440],0,0,-1)
    {
    Name = "I4C"
    }
   0.datalabel([1530,1476],0,0,-1)
    {
    Name = "I40"
    }
   0.datalabel([2034,612],2,0,-1)
    {
    Name = "I3A"
    }
   0.datalabel([2070,612],2,0,-1)
    {
    Name = "I3B"
    }
   0.datalabel([2106,612],2,0,-1)
    {
    Name = "I3C"
    }
   0.datalabel([2034,792],2,0,-1)
    {
    Name = "I4A"
    }
   0.datalabel([2070,792],2,0,-1)
    {
    Name = "I4B"
    }
   0.datalabel([2106,792],2,0,-1)
    {
    Name = "I4C"
    }
   0.recorder2_0([1998,252],0,0,1330)
    {
    FName = "stn1"
    FFMT = "2"
    Rstep = "50"
    Mfilter = "0"
    FREQ = "1"
    StnN = "EMTDC_Simulation"
    DevNo = "1"
    NChA = "6"
    NChD = "1"
    ABFMT = "0"
    MFILE = "0"
    NxHdr = "0"
    AMin = "0"
    AMax = "4096"
    ENTCAP = "0"
    Hdr1 = "Extra_Line_1"
    Hdr2 = "Extra_Line_2"
    Hdr3 = "Extra_Line_3"
    Hdr4 = "Extra_Line_4"
    Hdr5 = "Extra_Line_5"
    NA1 = "V1a"
    DA1 = "A1"
    VS1 = "0"
    VT1 = "0"
    UN1 = "A1"
    PH1 = "0"
    TR1 = "1"
    CT1 = "A1"
    NA2 = "V1b"
    DA2 = "A2"
    VS2 = "0"
    VT2 = "0"
    UN2 = "A2"
    PH2 = "0"
    TR2 = "1"
    CT2 = "A2"
    NA3 = "V1c"
    DA3 = "A3"
    VS3 = "0"
    VT3 = "0"
    UN3 = "A3"
    PH3 = "0"
    TR3 = "1"
    CT3 = "A3"
    NA4 = "I1a"
    DA4 = "A4"
    VS4 = "0"
    VT4 = "1"
    UN4 = "A4"
    PH4 = "0"
    TR4 = "1"
    CT4 = "A4"
    NA5 = "I1b"
    DA5 = "A5"
    VS5 = "0"
    VT5 = "1"
    UN5 = "A5"
    PH5 = "0"
    TR5 = "1"
    CT5 = "A5"
    NA6 = "I1c"
    DA6 = "A6"
    VS6 = "0"
    VT6 = "1"
    UN6 = "A6"
    PH6 = "0"
    TR6 = "1"
    CT6 = "A6"
    NA7 = "A7"
    DA7 = "A7"
    VS7 = "0"
    VT7 = "0"
    UN7 = "A7"
    PH7 = "0"
    TR7 = "1"
    CT7 = "A7"
    NA8 = "A8"
    DA8 = "A8"
    VS8 = "0"
    VT8 = "0"
    UN8 = "A8"
    PH8 = "0"
    TR8 = "1"
    CT8 = "A8"
    NA9 = "A9"
    DA9 = "A9"
    VS9 = "0"
    VT9 = "0"
    UN9 = "A9"
    PH9 = "0"
    TR9 = "1"
    CT9 = "A9"
    NA10 = "A10"
    DA10 = "A10"
    VS10 = "0"
    VT10 = "0"
    UN10 = "A10"
    PH10 = "0"
    TR10 = "1"
    CT10 = "A10"
    NA11 = "A11"
    DA11 = "A11"
    VS11 = "0"
    VT11 = "0"
    UN11 = "A11"
    PH11 = "0"
    TR11 = "1"
    CT11 = "A11"
    NA12 = "A12"
    DA12 = "A12"
    VS12 = "0"
    VT12 = "0"
    UN12 = "A12"
    PH12 = "0"
    TR12 = "1.0"
    CT12 = "A12"
    ND1 = "D1"
    DD1 = "D1"
    NT1 = "0"
    ND2 = "D2"
    DD2 = "D2"
    NT2 = "0"
    ND3 = "D3"
    DD3 = "D3"
    NT3 = "0"
    ND4 = "D4"
    DD4 = "D4"
    NT4 = "0"
    ND5 = "D5"
    DD5 = "D5"
    NT5 = "0"
    ND6 = "D6"
    DD6 = "D6"
    NT6 = "0"
    ND7 = "D7"
    DD7 = "D7"
    NT7 = "0"
    ND8 = "D8"
    DD8 = "D8"
    NT8 = "0"
    ND9 = "D9"
    DD9 = "D9"
    NT9 = "0"
    ND10 = "D10"
    DD10 = "D10"
    NT10 = "0"
    ND11 = "D11"
    DD11 = "D11"
    NT11 = "0"
    ND12 = "D12"
    DD12 = "D12"
    NT12 = "0"
    ND13 = "D13"
    DD13 = "D13"
    NT13 = "0"
    ND14 = "D14"
    DD14 = "D14"
    NT14 = "0"
    ND15 = "D15"
    DD15 = "D15"
    NT15 = "0"
    ND16 = "D16"
    DD16 = "D16"
    NT16 = "0"
    }
   0.datalabel([2106,324],0,0,-1)
    {
    Name = "Fault"
    }
   0.datalabel([2106,504],0,0,-1)
    {
    Name = "Fault"
    }
   0.datalabel([1638,1368],0,0,-1)
    {
    Name = "P3"
    }
   0.datalabel([1638,1404],0,0,-1)
    {
    Name = "Q3"
    }
   0.datalabel([1638,1242],0,0,-1)
    {
    Name = "Br3A"
    }
   0.datalabel([1638,1278],0,0,-1)
    {
    Name = "Br3B"
    }
   0.datalabel([1638,1314],0,0,-1)
    {
    Name = "Br3C"
    }
   -Wire-([1764,1242],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([1764,1242],0,0,-1)
    {
    Name = "Br4A"
    }
   0.datalabel([1764,1278],0,0,-1)
    {
    Name = "Br4B"
    }
   0.datalabel([1764,1314],0,0,-1)
    {
    Name = "Br4C"
    }
   0.datalabel([1764,1368],0,0,-1)
    {
    Name = "P4"
    }
   0.datalabel([1764,1404],0,0,-1)
    {
    Name = "Q4"
    }
   0.pgb([1440,1242],0,39439512,320)
    {
    Name = "V3a"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "-300.0"
    Max = "300.0"
    }
   0.pgb([1440,1278],0,39442288,400)
    {
    Name = "V3b"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "-300.0"
    Max = "300.0"
    }
   0.pgb([1440,1314],0,39445368,450)
    {
    Name = "V3c"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "-300.0"
    Max = "300.0"
    }
   0.pgb([1440,1368],0,39448280,910)
    {
    Name = "I3a"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-6.0"
    Max = "6.0"
    }
   0.pgb([1440,1404],0,39451192,830)
    {
    Name = "I3b"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-6.0"
    Max = "6.0"
    }
   0.pgb([1440,1440],0,39454104,760)
    {
    Name = "I3c"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-6.0"
    Max = "6.0"
    }
   0.pgb([1440,1476],0,39457016,710)
    {
    Name = "I30"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-2.5"
    Max = "2.5"
    }
   0.pgb([1566,1278],0,39459928,430)
    {
    Name = "V4b"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "-200.0"
    Max = "250.0"
    }
   0.pgb([1566,1368],0,39462840,890)
    {
    Name = "I4a"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "2.0"
    }
   0.pgb([1566,1404],0,39465752,810)
    {
    Name = "I4b"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "2.0"
    }
   0.pgb([1566,1440],0,39468664,730)
    {
    Name = "I4c"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "2.0"
    }
   0.pgb([1566,1476],0,39471752,700)
    {
    Name = "I40"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "2.0"
    }
   0.pgb([1674,1242],0,39474776,1120)
    {
    Name = "Br3a"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-0.1"
    Max = "0.1"
    }
   0.pgb([1674,1278],0,39477552,1080)
    {
    Name = "Br3b"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-0.1"
    Max = "0.1"
    }
   0.pgb([1674,1314],0,39480328,1030)
    {
    Name = "Br3c"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-0.1"
    Max = "0.1"
    }
   0.pgb([1674,1404],0,39483024,790)
    {
    Name = "Q3"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "MVAR"
    mrun = "0"
    Pol = "0"
    Min = "-50"
    Max = "50"
    }
   0.pgb([1800,1368],0,39485936,840)
    {
    Name = "P4"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "MW"
    mrun = "0"
    Pol = "0"
    Min = "-150"
    Max = "150"
    }
   0.pgb([1800,1404],0,39488848,750)
    {
    Name = "Q4"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "MVAR"
    mrun = "0"
    Pol = "0"
    Min = "-50"
    Max = "50"
    }
   0.pgb([1800,1278],0,39491760,1060)
    {
    Name = "Br4b"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-1.0"
    Max = "1.0"
    }
   0.pgb([1800,1314],0,39494536,990)
    {
    Name = "Br4c"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-1.0"
    Max = "1.0"
    }
   0.datalabel([648,738],0,0,-1)
    {
    Name = "F5"
    }
   0.datalabel([504,1242],2,0,-1)
    {
    Name = "B4"
    }
   0.breaker3([522,684],4,0,570)
    {
    Ctrl = "0"
    OPCUR = "0"
    ENAB = "0"
    CLVL = "0.0 [kA]"
    View = "1"
    ViewB = "1"
    DisPQ = "1"
    NAME = "B3"
    NAMEA = "BRKA"
    NAMEB = "BRKB"
    NAMEC = "BRKC"
    ROFF = "1.0e6 [ohm]"
    RON = "0.1 [ohm]"
    PRER = "0.5 [ohm]"
    TDA = "0.0 [s]"
    TDB = "0.0 [s]"
    TDC = "0.0 [s]"
    TDRA = "0.05 [s]"
    TDRB = "0.05 [s]"
    TDRC = "0.05 [s]"
    PostIns = "0"
    TDBOA = "0.005 [s]"
    IBRA = "I3A"
    IBRB = "I3B"
    IBRC = "I3C"
    IBR0 = "I30"
    SBRA = "Br3A"
    SBRB = "Br3B"
    SBRC = "Br3C"
    BP = "P3"
    BQ = "Q3"
    BOpen1 = "0"
    BOpen2 = "0"
    BOpen3 = "0"
    P = "-28.54 [MW]"
    Q = "2.791 [MVAR]"
    }
   0.pgb([936,1242],0,39501960,240)
    {
    Name = "V1a"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "-200.0"
    Max = "200.0"
    }
   0.pgb([1926,1242],0,39504928,420)
    {
    Name = "V1rms"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "220"
    Max = "250"
    }
   0.pgb([1926,1278],0,39507840,470)
    {
    Name = "V2rms"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "220"
    Max = "250"
    }
   -Wire-([486,576],0,0,-1)
    {
    Vertex="0,0;-144,0"
    }
   -Wire-([1026,576],0,0,-1)
    {
    Vertex="0,0;108,0"
    }
   0.datalabel([1062,702],0,0,-1)
    {
    Name = "F4"
    }
   0.datalabel([1062,684],0,0,-1)
    {
    Name = "FT4"
    }
   -Wire-([1080,576],0,0,-1)
    {
    Vertex="0,0;0,90"
    }
   0.pgb([1566,1314],0,39513528,480)
    {
    Name = "V4c"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "-200.0"
    Max = "250.0"
    }
   0.pgb([1188,1368],0,39516608,1010)
    {
    Name = "P1"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "MW"
    mrun = "0"
    Pol = "0"
    Min = "-150"
    Max = "150"
    }
   -Wire-([1872,288],0,0,-1)
    {
    Vertex="0,0;0,612"
    }
   0.datalabel([360,1260],0,0,-1)
    {
    Name = "Breaker"
    }
   0.unity([162,1350],0,0,620)
    {
    IType = "2"
    OType = "1"
    }
   0.datalabel([1494,1206],2,0,-1)
    {
    Name = "V4"
    }
   0.mux_array([180,1422],6,0,630)
    {
    DPath = "0"
    }
   0.datatap([432,1242],6,0,650)
    {
    Index = "2"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datatap([468,1242],6,0,560)
    {
    Index = "3"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datatap([108,1224],6,0,1230)
    {
    Index = "1"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datatap([144,1224],6,0,1220)
    {
    Index = "2"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datatap([180,1224],6,0,1210)
    {
    Index = "3"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datatap([216,1224],6,0,1200)
    {
    Index = "4"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datatap([252,1224],6,0,1190)
    {
    Index = "5"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datatap([288,1224],6,0,1180)
    {
    Index = "6"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datalabel([216,1224],2,0,-1)
    {
    Name = "FT4"
    }
   -Wire-([270,1242],0,0,-1)
    {
    Vertex="0,0;-180,0"
    }
   0.datatap([108,1476],0,0,1020)
    {
    Index = "1"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datatap([144,1476],0,0,1000)
    {
    Index = "2"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datatap([180,1476],0,0,980)
    {
    Index = "3"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datatap([216,1476],0,0,970)
    {
    Index = "4"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datatap([252,1476],0,0,940)
    {
    Index = "5"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datatap([288,1476],0,0,930)
    {
    Index = "6"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datalabel([288,1224],2,0,-1)
    {
    Name = "FT6"
    }
   0.datalabel([252,1476],0,0,-1)
    {
    Name = "F5"
    }
   -Wire-([270,1458],0,0,-1)
    {
    Vertex="0,0;-180,0"
    }
   0.datalabel([216,1476],0,0,-1)
    {
    Name = "F4"
    }
   0.breaker3([990,684],0,0,670)
    {
    Ctrl = "0"
    OPCUR = "0"
    ENAB = "0"
    CLVL = "0.0 [kA]"
    View = "1"
    ViewB = "1"
    DisPQ = "1"
    NAME = "B4"
    NAMEA = "BRKA"
    NAMEB = "BRKB"
    NAMEC = "BRKC"
    ROFF = "1.0e6 [ohm]"
    RON = "0.1 [ohm]"
    PRER = "0.5 [ohm]"
    TDA = "0.0 [s]"
    TDB = "0.0 [s]"
    TDC = "0.0 [s]"
    TDRA = "0.05 [s]"
    TDRB = "0.05 [s]"
    TDRC = "0.05 [s]"
    PostIns = "0"
    TDBOA = "0.005 [s]"
    IBRA = "I4A"
    IBRB = "I4B"
    IBRC = "I4C"
    IBR0 = "I40"
    SBRA = "Br4A"
    SBRB = "Br4B"
    SBRC = "Br4C"
    BP = "P4"
    BQ = "Q4"
    BOpen1 = "0"
    BOpen2 = "0"
    BOpen3 = "0"
    P = "29.42 [MW]"
    Q = "-8.132 [MVAR]"
    }
   0.unity([198,1350],4,0,1150)
    {
    IType = "2"
    OType = "1"
    }
   0.pgb([1674,1368],0,39546448,860)
    {
    Name = "P3"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "MW"
    mrun = "0"
    Pol = "0"
    Min = "-150"
    Max = "150"
    }
   0.datatap([540,1242],6,0,590)
    {
    Index = "5"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datatap([576,1242],6,0,610)
    {
    Index = "6"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datalabel([540,1206],2,0,-1)
    {
    Name = "Faulttype"
    }
   -Wire-([540,1242],0,0,-1)
    {
    Vertex="0,0;0,-36"
    }
   0.datalabel([576,1242],2,0,-1)
    {
    Name = "F_loc"
    }
   -Wire-([198,1314],0,0,-1)
    {
    Vertex="0,0;0,36"
    }
   -Wire-([234,1350],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([270,1350],2,0,-1)
    {
    Name = "Faulttype"
    }
   0.datalabel([126,1350],0,0,-1)
    {
    Name = "F_Loc"
    }
   -Sticky-([288,450],0)
    {
    Name = ""
    Font = 1
    Bounds = 288,450,378,486
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "SUBSTATION 1"
    }
   0.var([324,648],3,39556264,90)
    {
    Name = "Ph Angle"
    Group = "SS1"
    Display = "0"
    Max = "180"
    Min = "0.0"
    Value = "0.0"
    Units = "deg"
    Collect = "1"
    }
   0.var([270,648],3,39559544,80)
    {
    Name = "Voltage"
    Group = "SS1"
    Display = "0"
    Max = "500"
    Min = "0.0"
    Value = "230.0"
    Units = "kV"
    Collect = "1"
    }
   -Sticky-([1062,450],0)
    {
    Name = ""
    Font = 1
    Bounds = 1062,450,1152,486
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "SUBSTATION 2"
    }
   0.var([1206,648],5,39562744,130)
    {
    Name = "Voltage"
    Group = "SS2"
    Display = "0"
    Max = "500"
    Min = "0.0"
    Value = "230.0"
    Units = "kV"
    Collect = "1"
    }
   0.var([1152,648],5,39565784,120)
    {
    Name = "Ph Angle"
    Group = "SS2"
    Display = "0"
    Max = "180"
    Min = "-180"
    Value = "20.0"
    Units = "deg"
    Collect = "1"
    }
   0.source3R([306,576],6,0,530)
    {
    Name = "Source1"
    MVA = "100.0 [MVA]"
    Vm = "230.0 [kV]"
    F = "$(f)"
    Tc = "0.05 [s]"
    Ideal = "0"
    ZSeq = "1"
    Imp = "1"
    View = "1"
    details = "1"
    Z1 = "52.9 [ohm]"
    Phi1 = "80.0 [deg]"
    R1p = "1.0 [ohm]"
    X1p = "0.1 [ohm]"
    Z0 = "52.9 [ohm]"
    Phi0 = "80.0 [deg]"
    R0p = "1.0 [ohm]"
    X0p = "0.1 [ohm]"
    P = "S1W"
    Q = "S1Q"
    Ia = ""
    Ib = ""
    Ic = ""
    }
   0.datatap([504,1242],6,0,640)
    {
    Index = "4"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   -Wire-([558,1260],0,0,-1)
    {
    Vertex="0,0;-198,0"
    }
   0.datatap([396,1242],6,0,660)
    {
    Index = "1"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datalabel([1404,1368],0,0,-1)
    {
    Name = "I3A"
    }
   0.datalabel([1404,1440],0,0,-1)
    {
    Name = "I3C"
    }
   0.datalabel([1404,1404],0,0,-1)
    {
    Name = "I3B"
    }
   0.datamerge([450,1332],1,0,580)
    {
    N = "3"
    Type = "2"
    Disp = "1"
    }
   0.datalabel([486,1350],0,0,-1)
    {
    Name = "I3C"
    }
   -Wire-([504,1350],0,0,-1)
    {
    Vertex="0,0;0,18"
    }
   0.datalabel([504,1368],0,0,-1)
    {
    Name = "I3B"
    }
   0.datalabel([522,1350],0,0,-1)
    {
    Name = "I3A"
    }
   0.datalabel([450,1332],2,0,-1)
    {
    Name = "I3"
    }
   0.recorder2_0([1998,864],0,0,1240)
    {
    FName = "stn4"
    FFMT = "2"
    Rstep = "50"
    Mfilter = "0"
    FREQ = "1"
    StnN = "EMTDC_Simulation"
    DevNo = "4"
    NChA = "6"
    NChD = "1"
    ABFMT = "0"
    MFILE = "0"
    NxHdr = "0"
    AMin = "0"
    AMax = "4096"
    ENTCAP = "0"
    Hdr1 = "Extra_Line_1"
    Hdr2 = "Extra_Line_2"
    Hdr3 = "Extra_Line_3"
    Hdr4 = "Extra_Line_4"
    Hdr5 = "Extra_Line_5"
    NA1 = "V2a"
    DA1 = "A1"
    VS1 = "0"
    VT1 = "0"
    UN1 = "A1"
    PH1 = "0"
    TR1 = "1"
    CT1 = "A1"
    NA2 = "V2b"
    DA2 = "A2"
    VS2 = "0"
    VT2 = "0"
    UN2 = "A2"
    PH2 = "0"
    TR2 = "1"
    CT2 = "A2"
    NA3 = "V2c"
    DA3 = "A3"
    VS3 = "0"
    VT3 = "0"
    UN3 = "A3"
    PH3 = "0"
    TR3 = "1"
    CT3 = "A3"
    NA4 = "I2a"
    DA4 = "A4"
    VS4 = "0"
    VT4 = "1"
    UN4 = "A4"
    PH4 = "0"
    TR4 = "1"
    CT4 = "A4"
    NA5 = "I2b"
    DA5 = "A5"
    VS5 = "0"
    VT5 = "1"
    UN5 = "A5"
    PH5 = "0"
    TR5 = "1"
    CT5 = "A5"
    NA6 = "I2c"
    DA6 = "A6"
    VS6 = "0"
    VT6 = "1"
    UN6 = "A6"
    PH6 = "0"
    TR6 = "1"
    CT6 = "A6"
    NA7 = "A7"
    DA7 = "A7"
    VS7 = "0"
    VT7 = "0"
    UN7 = "A7"
    PH7 = "0"
    TR7 = "1"
    CT7 = "A7"
    NA8 = "A8"
    DA8 = "A8"
    VS8 = "0"
    VT8 = "0"
    UN8 = "A8"
    PH8 = "0"
    TR8 = "1"
    CT8 = "A8"
    NA9 = "A9"
    DA9 = "A9"
    VS9 = "0"
    VT9 = "0"
    UN9 = "A9"
    PH9 = "0"
    TR9 = "1"
    CT9 = "A9"
    NA10 = "A10"
    DA10 = "A10"
    VS10 = "0"
    VT10 = "0"
    UN10 = "A10"
    PH10 = "0"
    TR10 = "1"
    CT10 = "A10"
    NA11 = "A11"
    DA11 = "A11"
    VS11 = "0"
    VT11 = "0"
    UN11 = "A11"
    PH11 = "0"
    TR11 = "1"
    CT11 = "A11"
    NA12 = "A12"
    DA12 = "A12"
    VS12 = "0"
    VT12 = "0"
    UN12 = "A12"
    PH12 = "0"
    TR12 = "1.0"
    CT12 = "A12"
    ND1 = "D1"
    DD1 = "D1"
    NT1 = "0"
    ND2 = "D2"
    DD2 = "D2"
    NT2 = "0"
    ND3 = "D3"
    DD3 = "D3"
    NT3 = "0"
    ND4 = "D4"
    DD4 = "D4"
    NT4 = "0"
    ND5 = "D5"
    DD5 = "D5"
    NT5 = "0"
    ND6 = "D6"
    DD6 = "D6"
    NT6 = "0"
    ND7 = "D7"
    DD7 = "D7"
    NT7 = "0"
    ND8 = "D8"
    DD8 = "D8"
    NT8 = "0"
    ND9 = "D9"
    DD9 = "D9"
    NT9 = "0"
    ND10 = "D10"
    DD10 = "D10"
    NT10 = "0"
    ND11 = "D11"
    DD11 = "D11"
    NT11 = "0"
    ND12 = "D12"
    DD12 = "D12"
    NT12 = "0"
    ND13 = "D13"
    DD13 = "D13"
    NT13 = "0"
    ND14 = "D14"
    DD14 = "D14"
    NT14 = "0"
    ND15 = "D15"
    DD15 = "D15"
    NT15 = "0"
    ND16 = "D16"
    DD16 = "D16"
    NT16 = "0"
    }
   0.datalabel([2106,756],0,0,-1)
    {
    Name = "Fault"
    }
   0.datalabel([2106,936],0,0,-1)
    {
    Name = "Fault"
    }
   0.tpflt([396,666],0,0,1290)
    {
    Ctype = "1"
    OpCur = "0"
    Grnd = "1"
    View = "1"
    CLVL = "0.0 [kA]"
    RON = "Ron"
    ROFF = "1.0E6 [ohm]"
    A = "1"
    B = "0"
    C = "0"
    G = "1"
    Ifla = ""
    Iflb = ""
    Iflc = ""
    AG1 = "0"
    }
   0.tpflt([612,702],0,0,1280)
    {
    Ctype = "1"
    OpCur = "0"
    Grnd = "1"
    View = "1"
    CLVL = "0.0 [kA]"
    RON = "Ron"
    ROFF = "1.0E6 [ohm]"
    A = "1"
    B = "0"
    C = "0"
    G = "1"
    Ifla = ""
    Iflb = ""
    Iflc = ""
    AG1 = "0"
    }
   0.tpflt([900,468],4,0,1310)
    {
    Ctype = "1"
    OpCur = "0"
    Grnd = "1"
    View = "1"
    CLVL = "0.0 [kA]"
    RON = "Ron"
    ROFF = "1.0E6 [ohm]"
    A = "1"
    B = "0"
    C = "0"
    G = "1"
    Ifla = ""
    Iflb = ""
    Iflc = ""
    AG1 = "0"
    }
   0.tpflt([900,702],4,0,1260)
    {
    Ctype = "1"
    OpCur = "0"
    Grnd = "1"
    View = "1"
    CLVL = "0.0 [kA]"
    RON = "Ron"
    ROFF = "1.0E6 [ohm]"
    A = "1"
    B = "0"
    C = "0"
    G = "1"
    Ifla = ""
    Iflb = ""
    Iflc = ""
    AG1 = "0"
    }
   0.tpflt([1098,666],4,0,1270)
    {
    Ctype = "1"
    OpCur = "0"
    Grnd = "1"
    View = "1"
    CLVL = "0.0 [kA]"
    RON = "Ron"
    ROFF = "1.0E6 [ohm]"
    A = "1"
    B = "0"
    C = "0"
    G = "1"
    Ifla = ""
    Iflb = ""
    Iflc = ""
    AG1 = "0"
    }
   0.datalabel([108,1476],0,0,-1)
    {
    Name = "F1"
    }
   -Wire-([180,1530],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   0.datalabel([234,1530],0,0,-1)
    {
    Name = "Ron"
    }
   0.pgb([1188,1440],0,39603040,820)
    {
    Name = "PS1"
    Group = ""
    Display = "0"
    Scale = "1"
    Units = "MW"
    mrun = "0"
    Pol = "0"
    Min = "-300"
    Max = "300"
    }
   0.pgb([1188,1476],0,39605792,740)
    {
    Name = "QS1"
    Group = ""
    Display = "0"
    Scale = "1"
    Units = "MVAR"
    mrun = "0"
    Pol = "0"
    Min = "-100"
    Max = "100"
    }
   0.pgb([1314,1440],0,39608872,780)
    {
    Name = "PS2"
    Group = ""
    Display = "0"
    Scale = "1"
    Units = "MW"
    mrun = "0"
    Pol = "0"
    Min = "-300"
    Max = "300"
    }
   0.pgb([1314,1476],0,39611704,720)
    {
    Name = "QS2"
    Group = ""
    Display = "0"
    Scale = "1"
    Units = "MVAR"
    mrun = "0"
    Pol = "0"
    Min = "-100"
    Max = "100"
    }
   0.pgb([1188,1404],0,39614616,900)
    {
    Name = "Q1"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "MVAR"
    mrun = "0"
    Pol = "0"
    Min = "-50"
    Max = "50"
    }
   -Bus-([486,432],0,22462096,-1)
    {
    P1 = [0,0]
    P2 = [0,288]
    I = 1
    NAME = BUS1
    BASKV = 0
    IDE = 0
    GL = 0
    BL = 0
    AREA = 1
    ZONE = 0
    VM = 0
    VA = 0
    OWNER = 1
    }
   0.tpflt([612,468],0,0,1320)
    {
    Ctype = "1"
    OpCur = "0"
    Grnd = "1"
    View = "1"
    CLVL = "0.0 [kA]"
    RON = "Ron"
    ROFF = "1.0E6 [ohm]"
    A = "1"
    B = "0"
    C = "0"
    G = "1"
    Ifla = ""
    Iflb = ""
    Iflc = ""
    AG1 = "0"
    }
   -Bus-([1026,450],0,23128120,-1)
    {
    P1 = [0,0]
    P2 = [0,288]
    I = 1
    NAME = BUS2
    BASKV = 0
    IDE = 0
    GL = 0
    BL = 0
    AREA = 1
    ZONE = 0
    VM = 0
    VA = 0
    OWNER = 1
    }
   0.breaker3([990,468],0,0,680)
    {
    Ctrl = "0"
    OPCUR = "0"
    ENAB = "0"
    CLVL = "0.0 [kA]"
    View = "1"
    ViewB = "1"
    DisPQ = "1"
    NAME = "B2"
    NAMEA = "BRKA"
    NAMEB = "BRKB"
    NAMEC = "BRKC"
    ROFF = "1.0e6 [ohm]"
    RON = "0.1 [ohm]"
    PRER = "0.5 [ohm]"
    TDA = "0.0 [s]"
    TDB = "0.0 [s]"
    TDC = "0.0 [s]"
    TDRA = "0.05 [s]"
    TDRB = "0.05 [s]"
    TDRC = "0.05 [s]"
    PostIns = "0"
    TDBOA = "0.005 [s]"
    IBRA = "I2A"
    IBRB = "I2B"
    IBRC = "I2C"
    IBR0 = "I20"
    SBRA = "Br2A"
    SBRB = "Br2B"
    SBRC = "Br2C"
    BP = "P2"
    BQ = "Q2"
    BOpen1 = "0"
    BOpen2 = "0"
    BOpen3 = "0"
    P = "29.42 [MW]"
    Q = "-8.132 [MVAR]"
    }
   0.pgb([1566,1242],0,39624728,340)
    {
    Name = "V4a"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "-200.0"
    Max = "250.0"
    }
   0.pgb([1314,1242],0,39627640,1140)
    {
    Name = "Br2a"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-1.0"
    Max = "1.0"
    }
   0.pgb([1062,1242],0,39630304,260)
    {
    Name = "V2a"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "-150.0"
    Max = "150.0"
    }
   -Sticky-([630,1206],0)
    {
    Name = ""
    Font = 1
    Bounds = 630,1206,738,1242
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "OUTPUT CHANNELS"
    }
   0.mux_array([180,1278],0,0,1170)
    {
    DPath = "0"
    }
   0.var([144,1530],0,39634808,510)
    {
    Name = "Rf"
    Group = ""
    Display = "0"
    Max = "50"
    Min = "0.001"
    Value = "0.001"
    Units = ""
    Collect = "1"
    }
   0.annotation([144,1512],0,0,-1)
    {
    AL1 = "Rf"
    AL2 = ""
    }
   0.recorder2_0([1998,684],0,0,1250)
    {
    FName = "stn3"
    FFMT = "2"
    Rstep = "50"
    Mfilter = "0"
    FREQ = "1"
    StnN = "EMTDC_Simulation"
    DevNo = "3"
    NChA = "6"
    NChD = "1"
    ABFMT = "0"
    MFILE = "0"
    NxHdr = "0"
    AMin = "0"
    AMax = "4096"
    ENTCAP = "0"
    Hdr1 = "Extra_Line_1"
    Hdr2 = "Extra_Line_2"
    Hdr3 = "Extra_Line_3"
    Hdr4 = "Extra_Line_4"
    Hdr5 = "Extra_Line_5"
    NA1 = "V1a"
    DA1 = "A1"
    VS1 = "0"
    VT1 = "0"
    UN1 = "A1"
    PH1 = "0"
    TR1 = "1"
    CT1 = "A1"
    NA2 = "V1b"
    DA2 = "A2"
    VS2 = "0"
    VT2 = "0"
    UN2 = "A2"
    PH2 = "0"
    TR2 = "1"
    CT2 = "A2"
    NA3 = "V1c"
    DA3 = "A3"
    VS3 = "0"
    VT3 = "0"
    UN3 = "A3"
    PH3 = "0"
    TR3 = "1"
    CT3 = "A3"
    NA4 = "I1a"
    DA4 = "A4"
    VS4 = "0"
    VT4 = "1"
    UN4 = "A4"
    PH4 = "0"
    TR4 = "1"
    CT4 = "A4"
    NA5 = "I1b"
    DA5 = "A5"
    VS5 = "0"
    VT5 = "1"
    UN5 = "A5"
    PH5 = "0"
    TR5 = "1"
    CT5 = "A5"
    NA6 = "I1c"
    DA6 = "A6"
    VS6 = "0"
    VT6 = "1"
    UN6 = "A6"
    PH6 = "0"
    TR6 = "1"
    CT6 = "A6"
    NA7 = "A7"
    DA7 = "A7"
    VS7 = "0"
    VT7 = "0"
    UN7 = "A7"
    PH7 = "0"
    TR7 = "1"
    CT7 = "A7"
    NA8 = "A8"
    DA8 = "A8"
    VS8 = "0"
    VT8 = "0"
    UN8 = "A8"
    PH8 = "0"
    TR8 = "1"
    CT8 = "A8"
    NA9 = "A9"
    DA9 = "A9"
    VS9 = "0"
    VT9 = "0"
    UN9 = "A9"
    PH9 = "0"
    TR9 = "1"
    CT9 = "A9"
    NA10 = "A10"
    DA10 = "A10"
    VS10 = "0"
    VT10 = "0"
    UN10 = "A10"
    PH10 = "0"
    TR10 = "1"
    CT10 = "A10"
    NA11 = "A11"
    DA11 = "A11"
    VS11 = "0"
    VT11 = "0"
    UN11 = "A11"
    PH11 = "0"
    TR11 = "1"
    CT11 = "A11"
    NA12 = "A12"
    DA12 = "A12"
    VS12 = "0"
    VT12 = "0"
    UN12 = "A12"
    PH12 = "0"
    TR12 = "1.0"
    CT12 = "A12"
    ND1 = "D1"
    DD1 = "D1"
    NT1 = "0"
    ND2 = "D2"
    DD2 = "D2"
    NT2 = "0"
    ND3 = "D3"
    DD3 = "D3"
    NT3 = "0"
    ND4 = "D4"
    DD4 = "D4"
    NT4 = "0"
    ND5 = "D5"
    DD5 = "D5"
    NT5 = "0"
    ND6 = "D6"
    DD6 = "D6"
    NT6 = "0"
    ND7 = "D7"
    DD7 = "D7"
    NT7 = "0"
    ND8 = "D8"
    DD8 = "D8"
    NT8 = "0"
    ND9 = "D9"
    DD9 = "D9"
    NT9 = "0"
    ND10 = "D10"
    DD10 = "D10"
    NT10 = "0"
    ND11 = "D11"
    DD11 = "D11"
    NT11 = "0"
    ND12 = "D12"
    DD12 = "D12"
    NT12 = "0"
    ND13 = "D13"
    DD13 = "D13"
    NT13 = "0"
    ND14 = "D14"
    DD14 = "D14"
    NT14 = "0"
    ND15 = "D15"
    DD15 = "D15"
    NT15 = "0"
    ND16 = "D16"
    DD16 = "D16"
    NT16 = "0"
    }
   0.recorder2_0([1998,432],0,0,1300)
    {
    FName = "stn2"
    FFMT = "2"
    Rstep = "50"
    Mfilter = "0"
    FREQ = "1"
    StnN = "EMTDC_Simulation"
    DevNo = "2"
    NChA = "6"
    NChD = "1"
    ABFMT = "0"
    MFILE = "0"
    NxHdr = "0"
    AMin = "0"
    AMax = "4096"
    ENTCAP = "0"
    Hdr1 = "Extra_Line_1"
    Hdr2 = "Extra_Line_2"
    Hdr3 = "Extra_Line_3"
    Hdr4 = "Extra_Line_4"
    Hdr5 = "Extra_Line_5"
    NA1 = "V2a"
    DA1 = "A1"
    VS1 = "0"
    VT1 = "0"
    UN1 = "A1"
    PH1 = "0"
    TR1 = "1"
    CT1 = "A1"
    NA2 = "V2b"
    DA2 = "A2"
    VS2 = "0"
    VT2 = "0"
    UN2 = "A2"
    PH2 = "0"
    TR2 = "1"
    CT2 = "A2"
    NA3 = "V2c"
    DA3 = "A3"
    VS3 = "0"
    VT3 = "0"
    UN3 = "A3"
    PH3 = "0"
    TR3 = "1"
    CT3 = "A3"
    NA4 = "I2a"
    DA4 = "A4"
    VS4 = "0"
    VT4 = "1"
    UN4 = "A4"
    PH4 = "0"
    TR4 = "1"
    CT4 = "A4"
    NA5 = "I2b"
    DA5 = "A5"
    VS5 = "0"
    VT5 = "1"
    UN5 = "A5"
    PH5 = "0"
    TR5 = "1"
    CT5 = "A5"
    NA6 = "I2c"
    DA6 = "A6"
    VS6 = "0"
    VT6 = "1"
    UN6 = "A6"
    PH6 = "0"
    TR6 = "1"
    CT6 = "A6"
    NA7 = "A7"
    DA7 = "A7"
    VS7 = "0"
    VT7 = "0"
    UN7 = "A7"
    PH7 = "0"
    TR7 = "1"
    CT7 = "A7"
    NA8 = "A8"
    DA8 = "A8"
    VS8 = "0"
    VT8 = "0"
    UN8 = "A8"
    PH8 = "0"
    TR8 = "1"
    CT8 = "A8"
    NA9 = "A9"
    DA9 = "A9"
    VS9 = "0"
    VT9 = "0"
    UN9 = "A9"
    PH9 = "0"
    TR9 = "1"
    CT9 = "A9"
    NA10 = "A10"
    DA10 = "A10"
    VS10 = "0"
    VT10 = "0"
    UN10 = "A10"
    PH10 = "0"
    TR10 = "1"
    CT10 = "A10"
    NA11 = "A11"
    DA11 = "A11"
    VS11 = "0"
    VT11 = "0"
    UN11 = "A11"
    PH11 = "0"
    TR11 = "1"
    CT11 = "A11"
    NA12 = "A12"
    DA12 = "A12"
    VS12 = "0"
    VT12 = "0"
    UN12 = "A12"
    PH12 = "0"
    TR12 = "1.0"
    CT12 = "A12"
    ND1 = "D1"
    DD1 = "D1"
    NT1 = "0"
    ND2 = "D2"
    DD2 = "D2"
    NT2 = "0"
    ND3 = "D3"
    DD3 = "D3"
    NT3 = "0"
    ND4 = "D4"
    DD4 = "D4"
    NT4 = "0"
    ND5 = "D5"
    DD5 = "D5"
    NT5 = "0"
    ND6 = "D6"
    DD6 = "D6"
    NT6 = "0"
    ND7 = "D7"
    DD7 = "D7"
    NT7 = "0"
    ND8 = "D8"
    DD8 = "D8"
    NT8 = "0"
    ND9 = "D9"
    DD9 = "D9"
    NT9 = "0"
    ND10 = "D10"
    DD10 = "D10"
    NT10 = "0"
    ND11 = "D11"
    DD11 = "D11"
    NT11 = "0"
    ND12 = "D12"
    DD12 = "D12"
    NT12 = "0"
    ND13 = "D13"
    DD13 = "D13"
    NT13 = "0"
    ND14 = "D14"
    DD14 = "D14"
    NT14 = "0"
    ND15 = "D15"
    DD15 = "D15"
    NT15 = "0"
    ND16 = "D16"
    DD16 = "D16"
    NT16 = "0"
    }
   0.const([1710,216],1,0,20)
    {
    Name = ""
    Value = "10.0"
    }
   0.var([1800,288],0,39661128,30)
    {
    Name = "Stop"
    Group = ""
    Display = "0"
    Max = "1.0"
    Min = "0.0"
    Value = "0.55"
    Units = "s"
    Collect = "1"
    }
   0.var([1674,558],0,39664168,100)
    {
    Name = "Start"
    Group = ""
    Display = "0"
    Max = "1.0"
    Min = "0.0"
    Value = "0.15"
    Units = "s"
    Collect = "1"
    }
   0.select([1746,252],6,0,520)
    {
    A = "1"
    DPath = "1"
    COM = "Selector"
    }
   -Wire-([1710,288],0,0,-1)
    {
    Vertex="0,0;0,612"
    }
   0.const([1746,396],1,0,70)
    {
    Name = ""
    Value = "10.0"
    }
   0.select([1782,432],6,0,540)
    {
    A = "1"
    DPath = "1"
    COM = "Selector"
    }
   -Wire-([1782,252],0,0,-1)
    {
    Vertex="0,0;108,0"
    }
   -Wire-([1836,288],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Wire-([1818,432],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   -Wire-([1710,468],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.const([1746,648],1,0,160)
    {
    Name = ""
    Value = "10.0"
    }
   0.select([1782,684],6,0,170)
    {
    A = "1"
    DPath = "1"
    COM = "Selector"
    }
   0.const([1764,828],1,0,210)
    {
    Name = ""
    Value = "10.0"
    }
   0.select([1800,864],6,0,220)
    {
    A = "1"
    DPath = "1"
    COM = "Selector"
    }
   -Wire-([1872,900],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   -Wire-([1710,900],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Wire-([1710,720],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.var_switch([1746,180],1,39676792,10)
    {
    Name = "en Record1"
    Group = ""
    Display = "0"
    Value = "1"
    Max = "1"
    Min = "0"
    Ton = "ON"
    Toff = "OFF"
    }
   0.var_switch([1782,360],1,39679456,50)
    {
    Name = "en Record2"
    Group = ""
    Display = "0"
    Value = "1"
    Max = "1"
    Min = "0"
    Ton = "ON"
    Toff = "OFF"
    }
   0.var_switch([1782,612],1,39682176,150)
    {
    Name = "en Record3"
    Group = ""
    Display = "0"
    Value = "1"
    Max = "1"
    Min = "0"
    Ton = "ON"
    Toff = "OFF"
    }
   0.var_switch([1800,792],1,39684896,190)
    {
    Name = "en Record4"
    Group = ""
    Display = "0"
    Value = "1"
    Max = "1"
    Min = "0"
    Ton = "ON"
    Toff = "OFF"
    }
   0.datalabel([1278,972],4,0,-1)
    {
    Name = "Faulttype"
    }
   -Wire-([1278,972],0,0,-1)
    {
    Vertex="0,0;180,0"
    }
   -Wire-([1314,990],0,0,-1)
    {
    Vertex="0,0;144,0"
    }
   0.datalabel([1314,990],0,0,-1)
    {
    Name = "V1"
    }
   -Wire-([1458,1008],0,0,-1)
    {
    Vertex="0,0;-108,0"
    }
   0.datalabel([1350,1008],4,0,-1)
    {
    Name = "Fault"
    }
   -Wire-([1314,954],0,0,-1)
    {
    Vertex="0,0;144,0"
    }
   0.datalabel([1314,954],6,0,-1)
    {
    Name = "I3"
    }
   -Wire-([1350,936],0,0,-1)
    {
    Vertex="0,0;108,0"
    }
   0.datalabel([1350,936],4,0,-1)
    {
    Name = "Breaker"
    }
   -Sticky-([36,36],0)
    {
    Name = ""
    Font = 1
    Bounds = 36,36,648,216
    Alignment = 0
    Style = 0
    Arrow = 0
    Color = 0,15792890
    Text = "\
Description: 
- Two Thevinen Impedance sources connected via two parallel 100km transmission lines.  
- System voltage is 230kV settable via source equivalents.
- Simulates two substations connected via two transmission lines.
- Six fault positions for full fault control ahead and behind station relays.
- Four breakers are independently timed controlled. (Default is closed).
- Independent breaker pole tripping is possible."
    }
   -TLine-([648,468],0,21430712,-1)
    {
    Name = "LINE1"
    Date = 1144770343
    Freq = "$(f)"
    Length = "100.0 [km]"
    Dim = 3
    Mode = 1
    Vertex="0,0;18,0;198,0;216,0"
    PageLayer(A/A4,Landscape,16,[597,467],100)
     {
     0.Line_FreDep_Options([738,378],0,23237112,-1)
      {
      FS = "0.5 [Hz]"
      FE = "1.0E6 [Hz]"
      FT = "2000 [Hz]"
      ZMaxP = "20"
      AMaxP = "20"
      ZMaxE = "2 [%]"
      AMaxE = "2 [%]"
      Interp1 = "1"
      Output = "0"
      W1 = "100"
      W2 = "1000"
      W3 = "1"
      Inflen = "0"
      }
     0.Line_Ground([630,702],0,23238440,-1)
      {
      GRRES = "100.0 [ohm*m]"
      GPERM = "1.0"
      EarthForm = "0"
      }
     0.SequenceInfo([216,432],0,23238792,-1)
      {
      Mode = "0"
      X1 = "3.57448095"
      Y1 = "50.7762676"
      X2 = "3.57448095"
      Y2 = "50.7762676"
      X3 = "36.3152201"
      Y3 = "132.647323"
      X4 = "1.0e-005"
      Y4 = "0.000327117946"
      X5 = "0.0"
      Y5 = "0.0"
      X6 = "1.0e-005"
      Y6 = "0.000232266098"
      M1 = "50.9019279149"
      P1 = "85.9732100966"
      M2 = "50.9019279149"
      P2 = "85.9732100966"
      M3 = "137.528569795"
      P3 = "74.6891426178"
      M4 = "0.000327270760373"
      P4 = "88.249012563"
      M5 = "0.0"
      P5 = "0.0"
      M6 = "0.000232481268665"
      P6 = "87.5347062197"
      }
     0.Line_Tower_3_Delta([810,612],0,23239696,-1)
      {
      TName = "3H5"
      Y = "30 [m]"
      Y2 = "5 [m]"
      XC = "10 [m]"
      X = "0 [m]"
      ShuntG = "1.0E-10 [mho/m]"
      SHSag = "0"
      Transp = "1"
      NG = "2"
      ElimGW = "1"
      CDataType = "1"
      CName = "chukar"
      CLName = "..conductor.clb"
      RadiusC = "0.0203454 [m]"
      DCResC = "0.03206 [ohm/km]"
      SAGC = "10 [m]"
      NCondB = "1"
      BundSym = "0"
      SHBund = "1"
      BSP = ".4572 [m]"
      GDataType = "1"
      GName = "1/2\"HighStrengthSteel"
      GLName = "..conductor.clb"
      RadiusG = "0.0055245 [m]"
      DCResG = "2.8645 [ohm/km]"
      SAGG = "10 [m]"
      YG = "10 [m]"
      XG = "10 [m]"
      XB1 = "-0.1 [m]"
      YB1 = "0.1 [m]"
      XB2 = "-0.1 [m]"
      YB2 = "0.1 [m]"
      XB3 = "-0.1 [m]"
      YB3 = "0.1 [m]"
      XB4 = "-0.1 [m]"
      YB4 = "0.1 [m]"
      XB5 = "-0.1 [m]"
      YB5 = "0.1 [m]"
      XB6 = "-0.1 [m]"
      YB6 = "0.1 [m]"
      XB7 = "-0.1 [m]"
      YB7 = "0.1 [m]"
      XB8 = "-0.1 [m]"
      YB8 = "0.1 [m]"
      XB9 = "-0.1 [m]"
      YB9 = "0.1 [m]"
      XB10 = "-0.1 [m]"
      YB10 = "0.1 [m]"
      NC1 = "1"
      NC2 = "2"
      NC3 = "3"
      NG1 = "4"
      NG2 = "5"
      }
     }
    }
   -TLine-([648,684],0,21432424,-1)
    {
    Name = "LINE2"
    Date = 1144770344
    Freq = "$(f)"
    Length = "100.0 [km]"
    Dim = 3
    Mode = 1
    Vertex="0,0;18,0;198,0;216,0"
    PageLayer(A/A4,Landscape,16,[597,467],100)
     {
     0.Line_FreDep_Options([738,378],0,23255616,-1)
      {
      FS = "0.5 [Hz]"
      FE = "1.0E6 [Hz]"
      FT = "2000 [Hz]"
      ZMaxP = "20"
      AMaxP = "20"
      ZMaxE = "2 [%]"
      AMaxE = "2 [%]"
      Interp1 = "1"
      Output = "0"
      W1 = "100"
      W2 = "1000"
      W3 = "1"
      Inflen = "0"
      }
     0.Line_Ground([630,702],0,23256704,-1)
      {
      GRRES = "100.0 [ohm*m]"
      GPERM = "1.0"
      EarthForm = "0"
      }
     0.SequenceInfo([180,504],0,23257080,-1)
      {
      Mode = "0"
      X1 = "3.57448095"
      Y1 = "50.7762676"
      X2 = "3.57448095"
      Y2 = "50.7762676"
      X3 = "36.3152201"
      Y3 = "132.647323"
      X4 = "1.0e-005"
      Y4 = "0.000327117946"
      X5 = "0.0"
      Y5 = "0.0"
      X6 = "1.0e-005"
      Y6 = "0.000232266098"
      M1 = "50.9019279149"
      P1 = "85.9732100966"
      M2 = "50.9019279149"
      P2 = "85.9732100966"
      M3 = "137.528569795"
      P3 = "74.6891426178"
      M4 = "0.000327270760373"
      P4 = "88.249012563"
      M5 = "0.0"
      P5 = "0.0"
      M6 = "0.000232481268665"
      P6 = "87.5347062197"
      }
     0.Line_Tower_3_Delta([810,612],0,23258160,-1)
      {
      TName = "3H5"
      Y = "30 [m]"
      Y2 = "5 [m]"
      XC = "10 [m]"
      X = "0 [m]"
      ShuntG = "1.0E-10 [mho/m]"
      SHSag = "0"
      Transp = "1"
      NG = "2"
      ElimGW = "1"
      CDataType = "1"
      CName = "chukar"
      CLName = "..\\conductor.clb"
      RadiusC = "0.0203454 [m]"
      DCResC = "0.03206 [ohm/km]"
      SAGC = "10 [m]"
      NCondB = "1"
      BundSym = "0"
      SHBund = "1"
      BSP = ".4572 [m]"
      GDataType = "1"
      GName = "1/2\"HighStrengthSteel"
      GLName = "..\\conductor.clb"
      RadiusG = "0.0055245 [m]"
      DCResG = "2.8645 [ohm/km]"
      SAGG = "10 [m]"
      YG = "10 [m]"
      XG = "10 [m]"
      XB1 = "-0.1 [m]"
      YB1 = "0.1 [m]"
      XB2 = "-0.1 [m]"
      YB2 = "0.1 [m]"
      XB3 = "-0.1 [m]"
      YB3 = "0.1 [m]"
      XB4 = "-0.1 [m]"
      YB4 = "0.1 [m]"
      XB5 = "-0.1 [m]"
      YB5 = "0.1 [m]"
      XB6 = "-0.1 [m]"
      YB6 = "0.1 [m]"
      XB7 = "-0.1 [m]"
      YB7 = "0.1 [m]"
      XB8 = "-0.1 [m]"
      YB8 = "0.1 [m]"
      XB9 = "-0.1 [m]"
      YB9 = "0.1 [m]"
      XB10 = "-0.1 [m]"
      YB10 = "0.1 [m]"
      NC1 = "1"
      NC2 = "2"
      NC3 = "3"
      NG1 = "4"
      NG2 = "5"
      }
     }
    }
   -Wire-([918,684],0,0,-1)
    {
    Vertex="0,0;-54,0"
    }
   -Wire-([594,684],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Wire-([918,468],0,0,-1)
    {
    Vertex="0,0;-54,0"
    }
   0.source3R([1170,576],2,0,550)
    {
    Name = "Source2"
    MVA = "100.0 [MVA]"
    Vm = "230.0 [kV]"
    F = "$(f)"
    Tc = "0.05 [s]"
    Ideal = "0"
    ZSeq = "1"
    Imp = "1"
    View = "1"
    details = "1"
    Z1 = "52.9 [ohm]"
    Phi1 = "80.0 [deg]"
    R1p = "1.0 [ohm]"
    X1p = "0.1 [ohm]"
    Z0 = "52.9 [ohm]"
    Phi0 = "80.0 [deg]"
    R0p = "1.0 [ohm]"
    X0p = "0.1 [ohm]"
    P = "S2W"
    Q = "S2Q"
    Ia = ""
    Ib = ""
    Ic = ""
    }
   .Plots_B2([1512,846],0,0,200)
    {
    }
   .Plots_B1([1512,720],0,0,180)
    {
    }
   -SrcFile-([1476,576],0)
    {
   Name = "case3_Multi_run_global.emt\\Data.out"
    }
   .Controls([1512,972],4,0,600)
    {
    }
   -Sticky-([738,36],0)
    {
    Name = ""
    Font = 1
    Bounds = 738,36,1134,144
    Alignment = 0
    Style = 0
    Arrow = 0
    Color = 0,15792890
    Text = "\
This case uses global substitutions.  To change between 50Hz/60Hz. select Global Substitutions.  In the pop-upwindow, change the value of f to the desired frequency.
"
    }
   0.multimeter([576,468],0,0,40)
    {
    MeasI = "0"
    MeasV = "1"
    MeasP = "0"
    MeasQ = "0"
    RMS = "1"
    MeasPh = "0"
    S = "1.0 [MVA]"
    BaseV = "1.0 [kV]"
    TS = "0.02 [s]"
    Freq = "60.0 [Hz]"
    Dis = "0"
    CurI = ""
    VolI = "V1"
    P = ""
    Q = ""
    Vrms = "V1rms"
    Ph = ""
    hide1 = "0"
    hide2 = "0"
    Pd = ""
    Qd = ""
    Vd = ""
    }
   0.multimeter([936,468],4,0,60)
    {
    MeasI = "0"
    MeasV = "1"
    MeasP = "0"
    MeasQ = "0"
    RMS = "1"
    MeasPh = "0"
    S = "1.0 [MVA]"
    BaseV = "1.0 [kV]"
    TS = "0.02 [s]"
    Freq = "60.0 [Hz]"
    Dis = "0"
    CurI = ""
    VolI = "V2"
    P = ""
    Q = ""
    Vrms = "V2rms"
    Ph = ""
    hide1 = "0"
    hide2 = "0"
    Pd = ""
    Qd = ""
    Vd = ""
    }
   0.multimeter([576,684],0,0,110)
    {
    MeasI = "0"
    MeasV = "1"
    MeasP = "0"
    MeasQ = "0"
    RMS = "1"
    MeasPh = "0"
    S = "1.0 [MVA]"
    BaseV = "1.0 [kV]"
    TS = "0.02 [s]"
    Freq = "60.0 [Hz]"
    Dis = "0"
    CurI = ""
    VolI = "V3"
    P = ""
    Q = ""
    Vrms = "V3rms"
    Ph = ""
    hide1 = "0"
    hide2 = "0"
    Pd = ""
    Qd = ""
    Vd = ""
    }
   0.multimeter([936,684],4,0,140)
    {
    MeasI = "0"
    MeasV = "1"
    MeasP = "0"
    MeasQ = "0"
    RMS = "1"
    MeasPh = "0"
    S = "1.0 [MVA]"
    BaseV = "1.0 [kV]"
    TS = "0.02 [s]"
    Freq = "60.0 [Hz]"
    Dis = "0"
    CurI = ""
    VolI = "V4"
    P = ""
    Q = ""
    Vrms = "V4rms"
    Ph = ""
    hide1 = "0"
    hide2 = "0"
    Pd = ""
    Qd = ""
    Vd = ""
    }
   -Divider-([36,1080],0)
    {
    Size(1548,0)
    3D = 1
    Color = 9
    Style = 0
    Weight = 2
    }
   -Divider-([1584,1080],0)
    {
    Size(0,-1044)
    3D = 1
    Color = 9
    Style = 0
    Weight = 2
    }
   -Wire-([1890,1242],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([1890,1242],0,0,-1)
    {
    Name = "V1rms"
    }
   -Wire-([1890,1278],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([1890,1278],0,0,-1)
    {
    Name = "V2rms"
    }
   -Wire-([1890,1314],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([1890,1314],0,0,-1)
    {
    Name = "V3rms"
    }
   -Wire-([1890,1350],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([1890,1350],0,0,-1)
    {
    Name = "V4rms"
    }
   }
  }
 }

